#    inlineJstack.py - simple programm, that converts a multiline Java stack trace into a single line one.
#    Copyright (C) 2012, 2013  Frank Brueseke
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Lesser General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from optparse import OptionParser

parser = OptionParser()
parser.add_option("-i", "--input", dest="inputFile",
                  help="Input file containing measurement data.", metavar="FILE")
parser.add_option("-o", "--output", dest="outputFile",
                  help="Output file to write inlined measurement data to.", metavar="FILE")

(options, args) = parser.parse_args()

#################################################
# init file names:

lastDot = options.outputFile.rfind('.')
basefile = options.outputFile
if lastDot!=-1:
	basefile=basefile[:lastDot]
stackTraceFile = basefile+'.traces.txt'
rScriptFile = basefile+'.R'
rScriptOutFile  = basefile+'.R.out.txt'
rPdfFile = basefile+'.R.pdf'

print "using input file : "+options.inputFile
print "using output file: "+options.outputFile
print "using stacktrace output file: "+stackTraceFile
# print "using R script file: "+rScriptFile
# print "using file for R output: "+rScriptOutFile
# print "using R PDF file: "+rPdfFile

#################################################
# read file:

theLines = []

fobj = open(options.inputFile, "r")
for line in fobj:
	if line.startswith('IN') or line.startswith('OUT') or line.startswith('EXE'):
		theLines.append(line.replace('\n',','))
	elif line!=";Done":
		if line.startswith('org.cocome.') or line.startswith('org.hibernate.'):
			theLines[-1]=theLines[-1]+line.replace('\n',',')
		else:
			pass
	else:
		pass
fobj.close()

#################################################
# compress stack traces:

stackTraces={}
traceCount=1
fileReady=['key;thread;time;duration;stacktrace']
for item in theLines[1:]:
	splitted = item.split(';')
	traceAlias = '(%s) %s'%(str(traceCount), splitted[0].split('>')[-1].strip())
	if not splitted[4] in stackTraces:
		stackTraces[splitted[4]]=traceAlias
		traceCount+=1
	splitted[4]=stackTraces[splitted[4]]
	fileReady.append(';'.join(splitted))

#################################################
# write output file:

fobj = open(options.outputFile, "w")
for item in fileReady:
	print >> fobj, item
fobj.close()

#################################################
# write stack trace index to file:

fobj = open(stackTraceFile, "w")
print >> fobj, "key;stacktrace;palladio mapping"
for item in stackTraces.keys():
	print >> fobj, str(stackTraces[item]) + ";" + str(item).strip(",") + ";"
fobj.close()

print
print "All done!"
print "Have a nice day..."

import sys
sys.exit()
# >>>>>>>>>>>>>>>>>>>>>>>STOP HERE<<<<<<<<<<<<<<<<<<<<<<<<< #
# >>>>>>>>>>>>>>>>>>>>>>>STOP HERE<<<<<<<<<<<<<<<<<<<<<<<<< #
# >>>>>>>>>>>>>>>>>>>>>>>STOP HERE<<<<<<<<<<<<<<<<<<<<<<<<< #
#############################################################

#################################################
# create R script file:
# TODO cut off outliers?!
# TODO more diagrams (see Palladio)

fobj = open(rScriptFile, "w")
print >> fobj, """data <- read.csv2(file="%(outfile)s")
pdf(file="./%(rpdffile)s", paper="a4r", width=11, height=8)
uniques <- unique(data$stacktrace)
uniLen <- length(uniques)
for (trace in uniques){
        dataCol <- 0.001*0.001*data$duration[which(data$stacktrace==trace)]
	plot(0:10, type = "n", xaxt="n", yaxt="n", bty="n", xlab = "", ylab = "")
	title(main=trace)
	text(5, 9, paste("count: ", length(dataCol)))
	text(5, 8, paste("mean: ",  mean(dataCol))  )
	text(5, 7, paste("max: ",   max(dataCol))   )
	text(5, 6, paste("min: ",   min(dataCol))   )
	text(5, 5, paste("median: ",median(dataCol)))

	cluster.size<- c(1,10,125)
	dataCol.max <- max(dataCol)
	cluster.marr<- ceiling(dataCol.max/cluster.size)
	cluster.max <- max(cluster.marr[which(cluster.marr<100)], min(cluster.marr))
	cluster.size<- max(cluster.size[min(which(cluster.marr==cluster.max))], min(cluster.size))
	text(5,2, paste("cluster.max: ", cluster.max))
	text(5,1, paste("cluster.size: ", cluster.size))
	cluster.ele <- c(cluster.size*0:cluster.max)
	myXlab = paste(trace, " - ", cluster.max, " Cluster der Groesze ", cluster.size, "ms")
	hist(dataCol, breaks=cluster.ele, freq=FALSE, xlab=myXlab, ylab="relative Haeufigkeit", main="Verteilung Aufrufe")
}
bp<-boxplot(duration ~ stacktrace, data)
legend(x="topleft", legend=uniques)
dev.off()
""" % {
	'outfile' :options.outputFile,
	'rpdffile':rPdfFile,
}
fobj.close()

#################################################
# call R script file automatically:
import subprocess
fobj = open(rScriptOutFile, "w")
subprocess.call(args=("R", "--vanilla", "--file="+rScriptFile), stdout=fobj, stderr=fobj)
fobj.close()

