package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class GainLossGeneralizedMultiCommodityBalanceDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		// Retrieve the results and entities and names for all interesting variables
		String[] varnames = {"forment", "setarc", "unionsetoperandsarc", "unionsetoperandnamesarc", "setnode", "unionsetoperandsnode", "unionsetoperandnamesnode", "setcom", "unionsetoperandscom", "unionsetoperandnamescom", "varparsupply", "varparflow", "gainlossmult"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("forment")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.constraint;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Indexing with dummy indices
			String[] indexvarnames = {"setcom", "setnode"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setnode","unionsetoperandnamesnode");
			unionsetindexvarnames.put("setcom", "unionsetoperandnamescom");
			Hashtable<String,String[]> indexvarnamedummies = new Hashtable<String,String[]>();
			String[] kind = {"k"};
			indexvarnamedummies.put("setcom", kind);
			String[] iind = {"i" }; 
			indexvarnamedummies.put("setnode", iind);
			MyAMPLStatementXMLStructureHelper.insertIndexing(statementtypetag, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), data, entitiesandNames, indexvarnames, unionsetindexvarnames, indexvarnamedummies);
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Upper C-Expression to be separated by 
			Element cexpr = new Element("cexpr");
			statementtypetag.addContent(cexpr);
			
			//Left part of equality
			Element lefteqexpr = new Element("expr");
			cexpr.addContent(lefteqexpr);
			
			
			//Insert Balance Summand with a helper
			
			//Indexing
			String[] indexvarnamestwo = {"setarc"};
			Hashtable<String,String> unionsetindexvarnamestwo = new Hashtable<String,String>();
			unionsetindexvarnamestwo.put("setarc","unionsetoperandnames");
			Hashtable<String,String[]> indexvarnamedummiestwo = new Hashtable<String,String[]>();
			
			//Question: Do Problems, e.g., encounter for balance types. Or it works. Just make a call with (j,i) for the other way round
			String[] ijinds = {"i" , "j"}; 
			indexvarnamedummiestwo.put("setarc", ijinds);
			String[] ijkinds = {"i","j","k"};
			MyAMPLStatementXMLStructureHelper.insertSimpleOneVarSummationExpression(cexpr, entityname, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), ijkinds, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiestwo);
			
			
			
			//Minus
			Element aoperatorlow = new Element("aoperator_low");
			Element opmin = new Element("MINUS");
			opmin.setText("-");
			aoperatorlow.addContent(opmin);
			cexpr.addContent(aoperatorlow);
			
			//Insert Balance Summand with a helper
			
			//Just change order of i,j to j,i
			Hashtable<String,String[]> indexvarnamedummiesthree = new Hashtable<String,String[]>();
			String[] jiinds = {"j" , "i"}; 
			indexvarnamedummiesthree.put("setarc", jiinds);
			String[] jikinds = {"j","i","k"};
			
			//TODO new: Summation with a parameter summand
			MyAMPLStatementXMLStructureHelper.insertMultipleIndexSetsParamVarPairSummationExpression(cexpr, entityname, data.returnRelatedEntityNameforEntityName(entityname, "gainlossmult"), jikinds, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), jikinds, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiesthree);
			//MyAMPLStatementXMLStructureHelper.insertSimpleOneVarSummationExpression(cexpr, entityname, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), jikinds, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiesthree);
			

			
			//Equality
			Element eql = new Element("EQUAL");
			eql.setText("=");
			cexpr.addContent(eql);
			
			//Right part of equality
			String[] ikinds = {"i","k"}; 
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(cexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparsupply"), ikinds);
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);

		}
			
		return doc;
	}

}