package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class InhomogeneousGoodsCapacityMultiplierDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		// Retrieve the results and entities and names for all interesting variables (noninstantiability is not treated in this implementation)
		//System.out.println("Heres the number of resultblocks:" + results.size());
		String[] varnames = {"parvargmul", "omEntityType", "setarc", "unionsetoperandsarc", "unionsetoperandnamesarc", "setcom", "unionsetoperandscom", "unionsetoperandnamescom", "mathprops"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("parvargmul")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind;
			
			//Instantiate as Var or Param
			if(data.containsVariableTypingforEntity(entityname, "parvargmul")){
			entkind = EntityKind.var;}
			else{entkind = EntityKind.param;}
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Indexing with a helper:
			String[] indexvarnames = {"setarc","setcom"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setarc","unionsetoperandnamesarc");
			unionsetindexvarnames.put("setcom", "unionsetoperandnamescom");
			MyAMPLStatementXMLStructureHelper.insertSimpleIndexing(statementtypetag, entityname, data, entitiesandNames, indexvarnames, unionsetindexvarnames);
			
			//Mathprops with a helper:
			MyAMPLStatementXMLStructureHelper.insertMPropsforEntity(statementtypetag, entityname, "parvargmul", entkind, data);
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);

		}

		return doc;
	}

}