package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class LinearCommodityFlowCostGoalDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		// Retrieve the results and entities and names for all interesting variables 
		String[] varnames = {"goalent", "setarc", "unionsetoperandsarc", "unionsetoperandnames", "setcom", "unionsetoperandscom", "unionsetoperandnamescom", "varparcost", "varparflow"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("goalent")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.objectivemin;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			
			//Get back the objective tag
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Suppress indexing for objectives! --> No Indexing here
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Expression with Indexing Helpers
			Element oexpr = new Element("oexpr");
			statementtypetag.addContent(oexpr);
			Element exprforobj = new Element("expr");
			oexpr.addContent(exprforobj);
			
			//ropertor Sum  with a generous indexing. 
			Element roperator= new Element("roperator");
			Element sum= new Element("SUM");
			sum.setText("sum");
			roperator.addContent(sum);
			exprforobj.addContent(roperator);
			
			//Indexing of outer sum
			String[] indexvarnamesone = {"setcom"};
			Hashtable<String,String> unionsetindexvarnamesone = new Hashtable<String,String>();
			unionsetindexvarnamesone.put("setcom","unionsetoperandnamescom");
			Hashtable<String,String[]> indexvarnamedummiesone = new Hashtable<String,String[]>();
			
			//Question: Do Problems, e.g., encounter for balance types. Or it works. Just make a call with (j,i) for the other way round
			String[] kind = {"k"}; 
			indexvarnamedummiesone.put("setcom", kind);
			MyAMPLStatementXMLStructureHelper.insertIndexing(exprforobj, entityname, data, entitiesandNames, indexvarnamesone, unionsetindexvarnamesone, indexvarnamedummiesone);
			
			//Next lower expression level with brackets
			Element brackedinnersumexpr = new Element("expr");
			exprforobj.addContent(brackedinnersumexpr);
			
			//Left brackets
			Element lrbone = new Element("LROUNDBRACKET");
			lrbone.setText("(");
			brackedinnersumexpr.addContent(lrbone);
			
			//The expr in the brackets
			Element innersumexpr = new Element("expr");
			brackedinnersumexpr.addContent(innersumexpr);
			
			//Another sum-operator
			Element roperatortwo= new Element("roperator");
			Element sumtwo= new Element("SUM");
			sumtwo.setText("sum");
			roperatortwo.addContent(sumtwo);
			innersumexpr.addContent(roperatortwo);
			
			//Another Indexing
			String[] indexvarnamestwo = {"setarc"};
			Hashtable<String,String> unionsetindexvarnamestwo = new Hashtable<String,String>();
			unionsetindexvarnamestwo.put("setarc","unionsetoperandnamesarc");
			Hashtable<String,String[]> indexvarnamedummiestwo = new Hashtable<String,String[]>();
			
			//Question: Do Problems, e.g., encounter for balance types. Or it works. Just make a call with (j,i) for the other way round
			String[] ijinds = {"i" , "j"}; 
			indexvarnamedummiestwo.put("setarc", ijinds);
			MyAMPLStatementXMLStructureHelper.insertIndexing(innersumexpr, entityname, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiestwo);
			
			
			//Another inner-expr to be put in brackets
			Element innerbrackexpr = new Element("expr");
			innersumexpr.addContent(innerbrackexpr);
			
			//Left brackets
			Element lrbtwo = new Element("LROUNDBRACKET");
			lrbtwo.setText("(");
			innerbrackexpr.addContent(lrbtwo);
			
			//The most inner expr
			Element mulexpr = new Element("expr");
			innerbrackexpr.addContent(mulexpr);
			
			//Indice-Array:
			String[] ijkinds = {"i","j","k"};
			//Generate left expr content for Flow
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), ijkinds);
			
			//Generate aoperator
			Element aoper = new Element("aoperator_high");
			Element mul = new Element("MUL");
			mul.setText("*");
			aoper.addContent(mul);
			mulexpr.addContent(aoper);
			
			//Generate right expr content for Cost
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparcost"), ijkinds);
			
			//Right brackets
			Element rrbtwo = new Element("RROUNDBRACKET");
			rrbtwo.setText(")");
			innerbrackexpr.addContent(rrbtwo);
			
			//Right brackets
			Element rrbone = new Element("RROUNDBRACKET");
			rrbone.setText(")");
			brackedinnersumexpr.addContent(rrbone);
			
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);
	
		}
				
		return doc;
	}

}