package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class LinearSingleCommodityFlowCostGoalDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		// Retrieve the results and entities and names for all interesting variables 
		String[] varnames = {"goalent", "setarc", "unionsetoperandsarc", "unionsetoperandnames", "varparcost", "varparflow"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("goalent")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.objectivemin;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			
			//Get back the objective tag
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Suppress indexing for objectives! --> No Indexing here
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Expression with Indexing Helpers
			Element oexpr = new Element("oexpr");
			statementtypetag.addContent(oexpr);
			Element exprforobj = new Element("expr");
			oexpr.addContent(exprforobj);
			
			//ropertor Sum  with a generous indexing. 
			Element roperator= new Element("roperator");
			Element sum= new Element("SUM");
			sum.setText("sum");
			roperator.addContent(sum);
			exprforobj.addContent(roperator);
			
			//Indexing
			String[] indexvarnames = {"setarc"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setarc","unionsetoperandnames");
			Hashtable<String,String[]> indexvarnamedummies = new Hashtable<String,String[]>();
			
			//Question: Do Problems, e.g., encounter for balance types. Or it works. Just make a call with (j,i) for the other way round
			String[] ijinds = {"i" , "j"}; 
			indexvarnamedummies.put("setarc", ijinds);
			MyAMPLStatementXMLStructureHelper.insertIndexing(exprforobj, entityname, data, entitiesandNames, indexvarnames, unionsetindexvarnames, indexvarnamedummies);
			
			//Further nested statement parts under an expr
			
			//goalexpression
			Element goalexprinsum = new Element("expr");
			exprforobj.addContent(goalexprinsum);
			
			//Left brackets
			Element lrb = new Element("LROUNDBRACKET");
			lrb.setText("(");
			goalexprinsum.addContent(lrb);
			
			//The expr in the brackets
			Element mulexpr = new Element("expr");
			goalexprinsum.addContent(mulexpr);
			
			//Generate left expr content for Flow
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), ijinds);
			
			//Generate aoperator
			Element aoper = new Element("aoperator_high");
			Element mul = new Element("MUL");
			mul.setText("*");
			aoper.addContent(mul);
			mulexpr.addContent(aoper);
			
			//Generate right expr content for Cost
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparcost"), ijinds);
			
			//Right Brackets
			Element rrb = new Element("RROUNDBRACKET");
			rrb.setText(")");
			goalexprinsum.addContent(rrb);
			
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);
	
		}
				
		return doc;
	}

}