package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class LowerCapacityCollectionDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		// Retrieve the results and entities and names for all interesting variables (Noninstantiability is handled outside this method ?!)
		String[] varnames = {"parvarcap", "omEntityType", "setarc", "unionsetoperandsarc", "unionsetoperandnames", "mathprops"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("parvarcap")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind;
			
			//Instantiate as Var or Param
			if(data.containsVariableTypingforEntity(entityname, "parvarcap")){
			entkind = EntityKind.var;}
			else{entkind = EntityKind.param;}
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Indexing with a helper:
			String[] indexvarnames = {"setarc"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setarc","unionsetoperandsarc");
			MyAMPLStatementXMLStructureHelper.insertSimpleIndexing(statementtypetag, entityname, data, entitiesandNames, indexvarnames, unionsetindexvarnames);
			
			//Mathprops with a helper:
			MyAMPLStatementXMLStructureHelper.insertMPropsforEntity(statementtypetag, entityname, "parvarcap", entkind, data);
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);
			
			//?Enter a breakline into the document: Not here, xslt for string representation should match the ';' character.
		}
				
		return doc;
	}

}