package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class MultipleFlowParsResourceAvailabilityConstraintsLowDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		
		// Retrieve the results and entities and names for all interesting variables
		String[] varnames = {"forment", "setarc", "unionsetoperandsarc", "unionsetoperandnamesarc", "varparcap", "varpargoodmult", "expcomcapflowsumiri", "expcomcapflowsumiritype", "setcom", "unionsetoperandscom", "unionsetoperandnamescom", "varparflow"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("forment")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.constraint;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			
			
			//Indexing with dummy indices
			String[] indexvarnames = {"setarc"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setarc","unionsetoperandnamesarc");
			Hashtable<String,String[]> indexvarnamedummies = new Hashtable<String,String[]>();
			String[] ijinds = {"i" , "j"}; 
			indexvarnamedummies.put("setarc", ijinds);
			MyAMPLStatementXMLStructureHelper.insertIndexing(statementtypetag, entityname, data, entitiesandNames, indexvarnames, unionsetindexvarnames, indexvarnamedummies);
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Constraint-Exression
			Element cexpr = new Element("cexpr");
			statementtypetag.addContent(cexpr);
			
			//Generate left expr content for Cap
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(cexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparcap"), ijinds);
			

			//Generate LT
			Element lt = new Element("LT");
			lt.setText("<=");
			cexpr.addContent(lt);
			
			
			
			// Right content: Two Summands with a Helper
			Element outersumexpr = new Element("expr");
			cexpr.addContent(outersumexpr);
			
			//Always keep a last expression
			Element lastexpr = outersumexpr;
			//First call to helper for continuous commodities
			
			Collection<String> expressionsasList = data.returnMultipleRelatedEntitiesNamesforEntityName(entityname, "expcomcapflowsumiri");
			//Try to trim the collection with a cast (remove duplicates):
			HashSet<String> expressions = new HashSet<String>(expressionsasList);
			Iterator<String> it = expressions.iterator();
			
			//Commodity-Set Indexing helpers are constructed outside the following loop since they don't vary
			String[] indexvarnamestwo = {"setcom"};
			Hashtable<String,String> unionsetindexvarnamestwo = new Hashtable<String,String>();
			unionsetindexvarnamestwo.put("setcom","unionsetoperandnamescom");
			Hashtable<String,String[]> indexvarnamedummiestwo = new Hashtable<String,String[]>();
			String[] kind = {"k"}; 
			indexvarnamedummiestwo.put("setcom", kind);
			
			//Need a loop that adds an add expression pair for every summand!
			while (it.hasNext()){
				
				String expressioniri = it.next();
				String[] ijkinds = {"i","j","k"}; 
				
				if(data.containsOntologyTypeInformationforEntityName(expressioniri, "expcomcapflowsumiri", "http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#CommodityCapacityandFlowSummationExpression")){

				
				//Retrieve Parameter Data: Name and dummy indices
				String goodmultname = data.returnRelatedEntityNameforEntityName(expressioniri, "varpargoodmult");
				
				//Retrieve Variable Data
				String flowname = data.returnRelatedEntityNameforEntityName(expressioniri, "varparflow");
			
				//Build Sum-Expression by helper call, set-info is retrieved within call
				//TODO: Check that parameterizing with expressioniri for the entityname really leads to an indexing with the correct commodity-sets. In the
				//examples, this works an I even think it is correct :-)
				MyAMPLStatementXMLStructureHelper.insertMultipleIndexSetsParamVarPairSummationExpression(lastexpr, expressioniri, goodmultname, ijkinds, flowname, ijkinds, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiestwo);
				}
				else{
				//Retrieve Variable Data
				String flowname = data.returnRelatedEntityNameforEntityName(expressioniri, "varparflow");	
				//Build Sum-Expression by helper call, set-info is retrieved within call (with ijinds!)
				MyAMPLStatementXMLStructureHelper.insertSimpleOneVarSummationExpression(lastexpr, expressioniri, flowname, ijkinds, data, entitiesandNames, indexvarnamestwo, unionsetindexvarnamestwo, indexvarnamedummiestwo);
				}
				//If there is another Element comming, add a plus and an extra expression? Change Loop-Collection type or use an iterator?
				if(it.hasNext()){
				
					//New Plus
					Element aoper = new Element("aoperator_low");
					Element pls = new Element("PLUS");
					pls.setText("+");
					aoper.addContent(pls);
					lastexpr.addContent(aoper);
				
					//Add next Expression Element
					Element nextexpr = new Element("expr");
					lastexpr.addContent(nextexpr);
					lastexpr = nextexpr;
				}
			
			}

			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);

		}
		
				
		return doc;
	}

}