package de.dsor.ontooptmod.derivation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasonerFactory;

import de.derivo.sparqldlapi.*;
import de.derivo.sparqldlapi.exceptions.QueryEngineException;
import de.derivo.sparqldlapi.exceptions.QueryParserException;
import de.derivo.sparqldlapi.impl.QueryImpl;
import de.derivo.sparqldlapi.impl.QueryParserImpl;
import de.derivo.sparqldlapi.types.QueryType;

import de.dsor.ontooptmod.helpers.*;




/**
 * This class is used to manage and process queries given in SPARQL-DL language on OWL API Ontologies. To that purpose, the SPARQL-DL API is used.
 * @author Florian Stapel
 *
 */
public class MySPARQLDLQueryManager {

	/*
	// Query, Engine and QueryString
	private static final String examplequerystring0 =  " SELECT ?setnodeuri "
			+ " WHERE "
			+ " { "
			+	" Type (?setnodeuri, <http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl#Set>) "
			+ " } " ;
	
	private static final String examplequerystring1 = " PREFIX om: <http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl#> "
			+ " PREFIX sp: <http://www.semanticweb.org/florianstapel/ontologies/2014/8/Top-Set-Parameter.owl#> "
		    + " PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> "
		    + " SELECT ?setnodeuri "
			+ " WHERE "
			+ " { "
			+	" Type (?setnodeuri, om:Set) "
			+ " } " ;
	
	private static final String examplequerystring = " PREFIX om: <http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl#> "
			+ " PREFIX sp: <http://www.semanticweb.org/florianstapel/ontologies/2014/8/Top-Set-Parameter.owl#> "
		    + " PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> "
		    + " SELECT ?setarc ?setnode "
			+ " WHERE "
			+ " { "
			+	" PropertyValue(?setarcuri, sp:WithinCartProductTwoSame,  ?setnodeuri), "
			+	" Type (?setarcuri, om:Set),  "
			+	" Type (?setnodeuri, om:Set), "
			+	" PropertyValue(?setnodeuri, om:EName, ?setnode), "
			+	" PropertyValue(?setarcuri, om:EName, ?setarc) "
			+ " } " ;
	*/
	
	private QueryEngine queryEngine;
	private Query query;
	
	
	// Ontologies, Managers and Reasoners
	private OWLOntologyManager ontManager;
	private OWLOntology ont;
	private OWLReasoner rStructural;
	//private OWLReasoner rHermit;
	 private Reasoner rHermit;
	
	/**
	 * Constructor initializes OntologyManager, Ontology, Reasoners and QueryEngine
	 * @param ontManager
	 * @param ont
	 */
	public MySPARQLDLQueryManager(OWLOntologyManager ontManager, OWLOntology ont){
		this.ontManager = ontManager;
		this.ont = ont;
		
		this.rStructural = new StructuralReasonerFactory().createReasoner(ont);
		// Having trouble with instantiating a Hermit Reasoner via OWL API --> version conflict?
		//this.rHermit = new Reasoner.ReasonerFactory().createReasoner(ont);
		
		this.rHermit = new Reasoner(ont);
		
		// Query (with rHermit in original slides)
		this.queryEngine = QueryEngine.create(ontManager, rHermit);
	}
	
	/** 
	 * This method executes the query gat queryloc and stores the result at the location resultloc
	 * @param queryloc
	 * @param resultloc
	 */
	public void processQueryFromFileLocation(File queryloc, File resultloc){
		Query query = null;
		try {
			query = loadSPARQLDLQueryFromFile(queryloc);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.err.println("Error when loading DL Query from File: " + queryloc);
			e.printStackTrace();
		}
		
		this.storeQueryResultasXMLatFile(this.processQuerytoResult(query), resultloc);
	}
	

	/**
	 * Execute the currently stored Query and obtain the Result as an QueryResult Object
	 * @return
	 */
	/*
	@Deprecated public QueryResult executeCurrentQuery(){
		try {
			this.query = Query.create(examplequerystring);
		} catch (QueryParserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Error when parsing current SPARQL-DL Query: " + examplequerystring);
		}
		
		QueryResult res = null;
		try {
			res = queryEngine.execute(query);
		} catch (QueryEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Error when executing current SPARQL-DL Query: " + examplequerystring);
		}
		return res;
	}
	*/

	
	/**
	 * This method processesis a helper method to process some demo queries that were entered manually to the system.
	 * TODO: Real Implementation 
	 */
	@Deprecated public void processDemoQueries(){
		
		// TODO: Implementation: Retrieve all Entities from somewhere, query locidents from ontology, and then process
		// Actual dummy-implementation: Process all queries by hand
		processQueryfromProprietaryStringIdentifier("MDO-Network#ArcSet");
		processQueryfromProprietaryStringIdentifier("MDO-Network#NodeSet");
		processQueryfromProprietaryStringIdentifier("MDO-Network#FlowCollection");
		processQueryfromProprietaryStringIdentifier("MDO-Network#CapacityCollection");
		processQueryfromProprietaryStringIdentifier("MDO-Network#CostCollection");
		processQueryfromProprietaryStringIdentifier("MDO-Network#SupplyCollection");
		processQueryfromProprietaryStringIdentifier("OM-Network-Constraints#Balance");
		processQueryfromProprietaryStringIdentifier("OM-Network-Constraints#Capacity");
		processQueryfromProprietaryStringIdentifier("OM-Network-Constraints#GoalFlowCostLinear");
	}
	
	
	/**
	 * Process the Query identified by locIdent.
	 * For treatment and definition of locIdent watch the other methods of this class!
	 * @param locIdent
	 */
	@Deprecated public void processQueryfromProprietaryStringIdentifier(String locIdent){
		Query query = null;
		try {
			query = loadSPARQLDLQueryFromFile(MyOwlOntologyImportHelper.getFileLocationfromString(locIdent, DType.SPARQLDL_QUERY));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.err.println("Error when loading DL Query from File: " + locIdent);
			e.printStackTrace();
		}
		
		storeQueryResultasXMLforproprietaryResultIdentifier(processQuerytoResult(query), locIdent);
	}
	
	/**
	 * This method stores the QueryResult Argument in SPARQL XML Results format at the location obtained from locIdent:
	 * If MyOWLOntologyManagers static getFileLocation method returns a valid file location, the file will be stored there 
	 * Otherwise: TODO store at string location given by locIdent.
	 * @param res
	 * @param locIdent
	 */
	@Deprecated public void storeQueryResultasXMLforproprietaryResultIdentifier(QueryResult res, String locIdent){
		System.out.println("----------------Processing next Query Start--------------------");
		System.out.println("Here's the current Query Result as toString(): " + res.toString());
		
		org.jdom.Document resasXML = res.toXML();
		XMLOutputter out = new XMLOutputter();
		System.out.println("Here's a Query Result as SPARQL XML result format:" );
		try {
			out.output(resasXML, System.out);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// Now let's store it at the location given by MyOWLOntologyManagers static getFileLocation method
		
		try {
			FileWriter fwriter = new FileWriter(MyOwlOntologyImportHelper.getFileLocationfromString(locIdent, DType.SPARQL_RESULT));
			out.output(resasXML, fwriter);
			fwriter.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Exception when storing DL Query result as XML result format");
		}
		
		// TODO: Treatment of locIdent as File Location directly
		System.out.println("----------------Processing next Query End--------------------");
	}
	
	/**
	 * This method processes a query with the actuallyloaded configuration on ontology, manager and Query Processor
	 * and returns the result in a QueryResult Object.
	 * @param query
	 * @return
	 */
	
	
	public void storeQueryResultasXMLatFile(QueryResult res, File resultloc){
		System.out.println("----------------Processing next Query Start--------------------");
		System.out.println("Here's the current Query Result as toString(): " + res.toString());
		
		org.jdom.Document resasXML = res.toXML();
		XMLOutputter out = new XMLOutputter();
		System.out.println("Here's a Query Result as SPARQL XML result format:" );
		try {
			out.output(resasXML, System.out);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// Now let's store it at the location given by MyOWLOntologyManagers static getFileLocation method
		
		try {
			FileWriter fwriter = new FileWriter(resultloc);
			out.output(resasXML, fwriter);
			fwriter.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Exception when storing DL Query result as XML result format");
		}
		
		// TODO: Treatment of locIdent as File Location directly
		System.out.println("----------------Processing next Query End--------------------");
	}
	
	
	public QueryResult processQuerytoResult(Query query){
		QueryResult res = null;
		try {
			res = this.queryEngine.execute(query);
		} catch (QueryEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Error when executing a SPARQL-DL Query: " + query.toString());
		}
		return res;
	}
	
	
	/**
	 * This method loads a SPARQLDL Query from a File source and returns it as a Query object
	 * @param file
	 * @throws IOException
	 */
	public Query loadSPARQLDLQueryFromFile(File file) throws IOException{

		String queryString = this.readStringfromFile(file);
		Query query = null;
		try {
			query = Query.create(queryString);
		} catch (QueryParserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Error when parsing SPARQL-DL Query from string: " + queryString);
		}
		
		return query;
	}
	
	/**
	 * This method simply reads a File into a String by using a BufferedReader. It throws IOExceptions
	 * and inserts "newlines" into the string.
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public String readStringfromFile(File file) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(file));
		 StringBuilder sb = new StringBuilder();
		try{
			 String line = br.readLine();
			 
			 while(line != null){
				 sb.append(line);
				 sb.append("\n");
				 line = br.readLine();
			 }
			return sb.toString();
		}
		finally{br.close();}
	}
	
	
}
