package de.dsor.ontooptmod.derivation;

import java.io.*;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;


/**
 * This class provides functionality for parsing, executing managing/ storing results of SPARQL Queries. It therefore makes use of libraries from the APACHE JENA Project,
 * mainly jena-arq. 
 * TODO: Open issue how to obtain best compatiblity with OQL API Representations ussed in the rest of the code!
 * @author Florian Stapel
 * @deprecated
 */
public class MySPARQLQueryManager {

	private Query currentQuery;
	
	
	/**
	 * This method loads a SPARQL Query from a File source
	 * TODO: store that stuff and then exevure the query with a suitably loaded Jena-Model
	 * @param file
	 * @throws IOException
	 */
	public void loadSPARQLQueryFromFile(File file) throws IOException{

		String queryString = this.readStringfromFile(file);
		
		try{
		currentQuery = QueryFactory.create(queryString);
		System.out.println("Here's the parsed SPARQL Query:" + "\n" + currentQuery.toString());
		}
		catch(QueryException e){System.err.println("Error when creating SPARQL Query from String");}
	}
	
	/**
	 * This method simply reads a File into a String by using a BufferedReader. It throws IOExceptions
	 * and inserts "newlines" into the string.
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public String readStringfromFile(File file) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(file));
		 StringBuilder sb = new StringBuilder();
		try{
			 String line = br.readLine();
			 
			 while(line != null){
				 sb.append(line);
				 sb.append("\n");
				 line = br.readLine();
			 }
			return sb.toString();
		}
		finally{br.close();}
	}
}
