package de.dsor.ontooptmod.helpers;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

import org.semanticweb.owlapi.*;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

/**
 * This class provides helper methods to get file locations for ontologies, queries, xslts and all further documents processed by the applications. 
 * It's functionality is specific to the Optimization Ontology Modeling Project and all methods retrieve specific path's on a local machine based upon input keys!
 * @author Florian Stapel
 *
 */
public class MyOwlOntologyImportHelper {

	public static final String ontopathbase = "C:/Projekte/OntologicalOptimizationModeling/Ontologies";
	
	// Here come Hashtables based on finding files by IRIs
	
	static final Hashtable<IRI,IRI> mapOnt2Doc = new Hashtable<IRI,IRI>() {{
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/9/MDO-MathOpParams.owl"), IRI.create( ontopathbase + "/Vocabularies/MDO-MathOpParams/MDO-MathOpParams.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/9/MDO-TechConst.owl"), IRI.create( ontopathbase + "/Vocabularies/MDO-TechConst/MDO-TechConst.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/9/MDO-TimeHorizons.owl"), IRI.create( ontopathbase + "/Vocabularies/MDO-TimeHorizons/MDO-TimeHorizons.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/Top-Set-Parameter-Indexing.owl"), IRI.create( ontopathbase + "/Vocabularies/Top-Set-Parameter-Indexing/Top-Set-Parameter-Indexing.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/9/MDO-WaterNet.owl"), IRI.create( ontopathbase + "/Vocabularies/MDO-WaterNet/MDO-WaterNet.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl"), IRI.create( ontopathbase + "/Vocabularies/MDO-Network/MDO-Network.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl"), IRI.create( ontopathbase + "/Vocabularies/OM-Top-Optimization-Modeling/OM-Top-Optimization-Modeling.owl"));
		//put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/Top-Optimization-Modeling.owl"), IRI.create( ontopathbase + "/Vocabularies/OM-Top-Optimization-Modeling/OM-Top-Optimization-Modeling.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl"), IRI.create( ontopathbase + "/Vocabularies/OM-Network-Formulations/OM-Network-Formulations.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/6/OM.MProps.owl"), IRI.create(ontopathbase + "/Vocabularies/OM-MProps/OM-MProps.owl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2015/9/OM-WaterNet-Fomulations.owl"), IRI.create( ontopathbase + "/Vocabularies/OM-WaterNet-Formulations/OM-WaterNet-Formulations.owl"));
	}} ; 
	
	static final Hashtable<IRI,File> mapDLQueryIRI2QueryDoc = new Hashtable<IRI,File>(){{
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommodityCostCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommodityFlowCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommodityGainLossMultiplier.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityLowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommodityLowerCapacityCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommoditySupplyCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityUpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommodityUpperCapacityCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#InhomogeneousGoodsCapacityMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-InhomogeneousGoodsCapacityMultiplier.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#LowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-LowerCapacityCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-SingleCommodityCostCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-SingleCommodityGainLossMultiplier.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-SingleCommoditySupplyCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-SingleCommodityFlowCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#UpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-UpperCapacityCollection.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#ArcSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-ArcSet.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySetDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-CommoditySet.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#NodeSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-MDO-Network-HASH-NodeSet.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedMultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-GainLossGeneralizedMultiCommodityBalance.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedSingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-GainLossGeneralizedSingleCommodityBalance.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsLow.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsUp.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-MultiCommodityBalance.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsLow.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsUp.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-SingleCommodityBalance.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-SingleCommodityFlowBoundsUp.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperBundleConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-UpperBundleConstraints.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperResourceAvailabilityConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-UpperResourceAvailabilityConstraints.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-LinearCommodityFlowCostGoal.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearSingleCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-LinearSingleCommodityFlowCostGoal.txt"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearMultipleCommoditySetsFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/DLQuery-OM-Network-Formulations-HASH-LinearMultipleCommoditySetsFlowCostGoal.txt"));
	}};
	
	static final Hashtable<IRI,File> mapDLQueryIRI2QueryResultDoc = new Hashtable<IRI,File>(){{
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommodityCostCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommodityFlowCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommodityGainLossMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityLowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommodityLowerCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommoditySupplyCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityUpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommodityUpperCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#InhomogeneousGoodsCapacityMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-InhomogeneousGoodsCapacityMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#LowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-LowerCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-SingleCommodityCostCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-SingleCommodityGainLossMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-SingleCommoditySupplyCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-SingleCommodityFlowCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#UpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-UpperCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#ArcSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-ArcSet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySetDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-CommoditySet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#NodeSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-MDO-Network-HASH-NodeSet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedMultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-GainLossGeneralizedMultiCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedSingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-GainLossGeneralizedSingleCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsLow.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-MultiCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsLow.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-SingleCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-SingleCommodityFlowBoundsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperBundleConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-UpperBundleConstraints.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperResourceAvailabilityConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-UpperResourceAvailabilityConstraints.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-LinearCommodityFlowCostGoal.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearSingleCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-LinearSingleCommodityFlowCostGoal.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearMultipleCommoditySetsFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/QueryResult-OM-Network-Formulations-HASH-LinearMultipleCommoditySetsFlowCostGoal.xml"));
	}};
	
	static final Hashtable<IRI,File> mapDLQueryIRI2XMLStatementResultDoc = new Hashtable<IRI,File>(){{
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommodityCostCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommodityFlowCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommodityGainLossMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityLowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommodityLowerCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommoditySupplyCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityUpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommodityUpperCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#InhomogeneousGoodsCapacityMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-InhomogeneousGoodsCapacityMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#LowerCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-LowerCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityCostCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-SingleCommodityCostCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityGainLossMultiplierDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-SingleCommodityGainLossMultiplier.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommoditySupplyCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-SingleCommoditySupplyCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityFlowCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-SingleCommodityFlowCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#UpperCapacityCollectionDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-UpperCapacityCollection.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#ArcSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-ArcSet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySetDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-CommoditySet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#NodeSetDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-MDO-Network-HASH-NodeSet.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedMultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-GainLossGeneralizedMultiCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedSingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-GainLossGeneralizedSingleCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsLow.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultiCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-MultiCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsLowDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsLow.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityBalanceDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-SingleCommodityBalance.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityFlowBoundsUpDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-SingleCommodityFlowBoundsUp.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperBundleConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-UpperBundleConstraints.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperResourceAvailabilityConstraintsDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-UpperResourceAvailabilityConstraints.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-LinearCommodityFlowCostGoal.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearSingleCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/Statement-OM-Network-Formulations-HASH-LinearSingleCommodityFlowCostGoal.xml"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearMultipleCommoditySetsFlowCostGoalDLQuery"), new File(ontopathbase +"/Statement-Derivation/Statement-OM-Network-Formulations-HASH-LinearMultipleCommoditySetsFlowCostGoal.xml"));
	}};
	
	static final Hashtable<IRI,File> mapXSLTIRI2Doc = new Hashtable<IRI,File>(){{
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityCostCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommodityCostCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityFlowCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommodityFlowCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityGainLossMultiplierXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommodityGainLossMultiplier.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityLowerCapacityCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommodityLowerCapacityCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySupplyCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommoditySupplyCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommodityUpperCapacityCollectionXSL"), new File(ontopathbase +"/Statement-Derivation/MDO-Network-HASH-CommodityUpperCapacityCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#InhomogeneousGoodsCapacityMultiplierXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-InhomogeneousGoodsCapacityMultiplier.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#LowerCapacityCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-LowerCapacityCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityCostCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-SingleCommodityCostCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityGainLossMultiplierXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-SingleCommodityGainLossMultiplier.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommoditySupplyCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-SingleCommoditySupplyCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#SingleCommodityFlowCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-SingleCommodityFlowCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#UpperCapacityCollectionXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-UpperCapacityCollection.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#ArcSetXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-ArcSet.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#CommoditySetXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-CommoditySet.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl#NodeSetXSL"), new File(ontopathbase + "/Statement-Derivation/MDO-Network-HASH-NodeSet.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedMultiCommodityBalanceXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-GainLossGeneralizedMultiCommodityBalance.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#GainLossGeneralizedSingleCommodityBalanceXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-GainLossGeneralizedSingleCommodityBalance.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsLowXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsLow.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#IndividualCommodityFlowBoundsUpXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-IndividualCommodityFlowBoundsUp.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultiCommodityBalanceXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-MultiCommodityBalance.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsLowXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsLow.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#MultipleFlowParsResourceAvailabilityConstraintsUpXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-MultipleFlowParsResourceAvailabilityConstraintsUp.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityBalanceXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-SingleCommodityBalance.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#SingleCommodityFlowBoundsUpXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-SingleCommodityFlowBoundsUp.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperBundleConstraintsXSL"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-UpperBundleConstraints.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#UpperResourceAvailabilityConstraintsXSD"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-UpperResourceAvailabilityConstraints.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-LinearCommodityFlowCostGoal.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearSingleCommodityFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-LinearSingleCommodityFlowCostGoal.xsl"));
		put(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Formulations.owl#LinearMultipleCommoditySetsFlowCostGoalDLQuery"), new File(ontopathbase + "/Statement-Derivation/OM-Network-Formulations-HASH-LinearMultipleCommoditySetsFlowCostGoal.xsl"));
	}};

	
	//Here come Hashtables based on finding files by string identifiers
	//The following content is outdated. If you want to reuse it, fix the paths to a more portable variant as above
	//TODO: The following six tables have to be changed to portable variants as done above. Just add a base ontology-file location string
	
	static final Hashtable<String,File> mapXSD2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-ArcSet.xsd"));
		put("MDO-Network#NodeSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-NodeSet.xsd"));
		put("MDO-Network#FlowCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-FlowCollection.xsd"));
		put("MDO-Network#CapacityCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-CapacityCollection.xsd"));
		put("MDO-Network#CostCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-CostCollection.xsd"));
		put("MDO-Network#SupplyCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-SupplyCollection.xsd"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-Balance.xsd"));
		put("OM-Network-Constraints#Capacity", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-Capacity.xsd"));
		put("OM-Network-Constraints#GoalFlowCostLinear", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-GoalFlowCostLinear.xsd"));
		put("AMPL-Statements-XML-Grammar", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/AMPL-Statements-XML-Grammar.xsd"));
	}};
	
	static final Hashtable<String,File> mapDLQuery2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-ArcSet.txt"));
		put("MDO-Network#NodeSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-NodeSet.txt"));
		put("MDO-Network#FlowCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-FlowCollection.txt"));
		put("MDO-Network#CapacityCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-CapacityCollection.txt"));
		put("MDO-Network#CostCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-CostCollection.txt"));
		put("MDO-Network#SupplyCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-MDO-Network-HASH-SupplyCollection.txt"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-OM-Network-Constraints-HASH-Balance.txt"));
		put("OM-Network-Constraints#Capacity", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-OM-Network-Constraints-HASH-Capacity.txt"));
		put("OM-Network-Constraints#GoalFlowCostLinear", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/DLQuery-OM-Network-Constraints-HASH-GoalFlowCostLinear.txt"));
	}};
	
	
	
	 // Content for SPARQL Queries is deprecated. Switched to SPARQL-DL!
	
	static final Hashtable<String,File> mapQuery2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Query-MDO-Network-HASH-ArcSet.txt"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Query-OM-Network-Constraints-HASH-Balance.txt"));
	}};
	
	static final Hashtable<String,File> mapQueryResult2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-ArcSet.xml"));
		put("MDO-Network#NodeSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-NodeSet.xml"));
		put("MDO-Network#FlowCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-FlowCollection.xml"));
		put("MDO-Network#CapacityCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-CapacityCollection.xml"));
		put("MDO-Network#CostCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-CostCollection.xml"));
		put("MDO-Network#SupplyCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-MDO-Network-HASH-SupplyCollection.xml"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-OM-Network-Constraints-HASH-Balance.xml"));
		put("OM-Network-Constraints#Capacity", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-OM-Network-Constraints-HASH-Capacity.xml"));
		put("OM-Network-Constraints#GoalFlowCostLinear", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/QueryResult-OM-Network-Constraints-HASH-GoalFlowCostLinear.xml"));
	}};
	
	static final Hashtable<String,File> mapXSLT2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-ArcSet.xsl"));
		put("MDO-Network#NodeSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-NodeSet.xsl"));
		put("MDO-Network#FlowCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-FlowCollection.xsl"));
		put("MDO-Network#CapacityCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-CapacityCollection.xsl"));
		put("MDO-Network#CostCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-CostCollection.xsl"));
		put("MDO-Network#SupplyCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/MDO-Network-HASH-SupplyCollection.xsl"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-Balance.xsl"));
		put("OM-Network-Constraints#Capacity", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-Capacity.xsl"));
		put("OM-Network-Constraints#GoalFlowCostLinear", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/OM-Network-Constraints-HASH-GoalFlowCostLinear.xsl"));
	}};
	
	static final Hashtable<String,File> mapStatementResult2Doc = new Hashtable<String,File>(){{
		put("MDO-Network#ArcSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-ArcSet.xml"));
		put("MDO-Network#NodeSet", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-NodeSet.xml"));
		put("MDO-Network#FlowCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-FlowCollection.xml"));
		put("MDO-Network#CapacityCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-CapacityCollection.xml"));
		put("MDO-Network#CostCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-CostCollection.xml"));
		put("MDO-Network#SupplyCollection", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-MDO-Network-HASH-SupplyCollection.xml"));
		put("OM-Network-Constraints#Balance", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-OM-Network-Constraints-HASH-Balance.xml"));
		put("OM-Network-Constraints#Capacity", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-OM-Network-Constraints-HASH-Capacity.xml"));
		put("OM-Network-Constraints#GoalFlowCostLinear", new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/Statement-OM-Network-Constraints-HASH-GoalFlowCostLinear.xml"));
	}};
	
	
	/*
	 * Really dirty but due to lacks in the owl api: This method returns a document IRI for an ontology IRI
	 */
	public static IRI getDocumentIRIforOntology (IRI iri){
		return mapOnt2Doc.get(iri);
	}
	
	
	/**
	 * This method returns a File that represents a location on the demo machine. Input is the document's identifier as an IRI and an enum type
	 * that specifies the type of document to be retrieved.
	 * @param docname
	 * @param d
	 * @return
	 */
	public static File getFileLocationfromIRI(IRI docname, DType d){
		
		File resultval = null;
		
		switch(d){
		case SPARQLDL_QUERY: resultval = mapDLQueryIRI2QueryDoc.get(docname);
			break;
		case SPARQL_RESULT: resultval = mapDLQueryIRI2QueryResultDoc.get(docname);
			break;
		case STATEMENT_RESULT: resultval =  mapDLQueryIRI2XMLStatementResultDoc.get(docname);
			break;
		case XSLT: resultval = mapXSLTIRI2Doc.get(docname);
			break;
		//Open question: How are Statement Results generated
		//case STATEMENT_RESULT: resultval = mapStatementResult2Doc.get(docname);
		//	break;
		default: System.err.println("Mistake when trying to find a document source of type " + d + "from IRI");
		 		 break;	 
		}
		if(resultval == null) {System.err.println("Not able to return document for docname: " + docname.toString() + "of type " + d.toString());}
		return resultval;
	}
	
	/**
	 * This method returns a File that represents a location on the demo machine. Input is the document's name as a string and an enum type
	 * that specifies the type of document to be retrieved.
	 * @param docname
	 * @param d
	 * @return
	 */
	public static File getFileLocationfromString(String docname, DType d){
		
		File resultval = null;
		
		switch(d){
		case XSD: resultval = mapXSD2Doc.get(docname);
			break;
		case SPARQLDL_QUERY: resultval = mapDLQuery2Doc.get(docname);
			break;
		case SPARQL_QUERY: resultval = mapQuery2Doc.get(docname);
			break;
		case SPARQL_RESULT: resultval = mapQueryResult2Doc.get(docname);
			break;
		case XSLT: resultval = mapXSLT2Doc.get(docname);
			break;
		case STATEMENT_RESULT: resultval = mapStatementResult2Doc.get(docname);
			break;
		default: System.err.println("Mistake when trying to find a document source of type " + d);
		 		 break;	 
		}
		return resultval;
	}
	
	
	/**
	 * This method simply returns the current path (on the demo machine) of a xsl document for in order extracting leave node content 
	 * @return
	 */
	public static File getXMLLeaveContentInOrdertoTextLocation(){
	return new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/XMLLeaveContentInOrdertoText.xsl");
	}
	

/**
 * This method adds allOntology-Locations of Vocabularies under a hard coded folder on the demo machine to the passed OWLOntologyManager in form of IRI Mappers.
 * @param manager
 * @deprecated
 */
	@Deprecated static void addLocalVocabularyIRIMappers(OWLOntologyManager manager){
		try{
			
			
			// Trying to use the AutoIRIMapper (which does not seem to work anyhow)
			/*
			 * 			AutoIRIMapper mapper = new AutoIRIMapper(new File("C:\\Projekte\\OntologicalOptimizationModeling\\Ontologies\\Vocabularies\\MDO-Network\\MDO-Network.owl"), true);
						mapper.update();
						manager.addIRIMapper(mapper);
						System.out.println(mapper.getFileExtensions().toString());
						System.out.println(mapper.getOntologyIRIs().toString());
			 *	Comment: OWL API's auto IRI Mapper does not seem to work on owl.xml Files.
			 *  See the code on http://grepcode.com/file/repo1.maven.org/maven2/net.sourceforge.owlapi/owlapi-api/3.3/org/semanticweb/owlapi/util/AutoIRIMapper.java
			 *
			 */
			
			// Add all mappings manually
			SimpleIRIMapper mapperSP = new SimpleIRIMapper(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/Top-Set-Parameter.owl"), IRI.create("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Vocabularies/Top-Set-Parameter/Top-Set-Parameter.owl"));
			manager.addIRIMapper(mapperSP);
			SimpleIRIMapper mapperMDONW = new SimpleIRIMapper(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/MDO-Network.owl"), IRI.create("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Vocabularies/MDO-Network/MDO-Network.owl"));
			manager.addIRIMapper(mapperMDONW);
			SimpleIRIMapper mapperOM = new SimpleIRIMapper(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl"), IRI.create("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Vocabularies/OM-Top-Optimization-Modeling/OM-Top-Optimization-Modeling.owl"));
			manager.addIRIMapper(mapperOM);
			SimpleIRIMapper mapperOMNCons = new SimpleIRIMapper(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM-Network-Constraints.owl"), IRI.create("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Vocabularies/OM-Network-Constraints/OM-Network-Constraints.owl"));
			manager.addIRIMapper(mapperOMNCons);
			
			
			// Test a single mapper:
			/*
			try{
			System.out.println(mapperOM.getDocumentIRI(IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl")).toString());
			}
			catch(Exception e){System.err.println("Unknown Exception: Was trying to get a just added Document IRI");}
			*/
		}
		catch(NullPointerException e){System.err.println("NullpointerException: Something gone wrong when adding local Vocabulary IRIs");}
	}
}
