param kL01 > 0, integer;
param aStartEnd{0..1};
param stepWidth = (aStartEnd[1] - aStartEnd[0]) / kL01;
param aComp{l in 0..kL01} = if l = 0 then aStartEnd[0] else aComp[l-1] + stepWidth;
param bComp{l in 0..kL01} = if l = 0 then aStartEnd[0] * abs(aStartEnd[0]) else aComp[l] * abs(aComp[l]);
var zL01{Pipes, 1..kL01} >= 0;
var yL01{Pipes, 1..(kL01 - 1)} binary; 
s.t. FlowRepLinL01{(i,j) in Pipes}: Q[i,j] = aComp[0] + sum{l in 1..kL01}(zL01[i,j,l]);
s.t. HeadLossRepLinL01{(i,j) in Pipes}: r[i,j] * ( bComp[0] +  sum{l in 1..kL01}( ((bComp[l] - bComp[l-1]) / (aComp[l] - aComp[l-1])) * zL01[i,j,l] )) = H[i] - H[j];
s.t. Boundz01{(i,j) in Pipes}: zL01[i,j,1] <= aComp[1] - aStartEnd[0];
s.t. ziFullSegmentLengthTill{(i,j) in Pipes, l in 1..(kL01-1)}: zL01[i,j,l] >= (aComp[l] - aComp[l-1]) * yL01[i,j,l];
s.t. ziSegmentLengthBound{(i,j) in Pipes, l in 1..(kL01-1)}: zL01[i,j,l+1] <= (aComp[l+1] - aComp[l]) * yL01[i,j,l];


