set Nodes;
set FullPipes within {Nodes,Nodes};
set Pumps within FullPipes;
param T > 0;
param alpha >0;
param cDeact > 0, <= 0.5;
param cOne > 0.5, < 2;
param cTwo > 1/3, < 2;
var Q{FullPipes, 0..T};
s.t. PumpActivationOnePeriodForbiddenNLP{(i,j) in Pumps, t in 0..(T-2)}: 
(cOne + 1) * Q[i,j,t] + (cOne - 2) * Q[i,j,t+1] + (cOne + 1) * Q[i,j,t+2] >= 0;
s.t. PumpActivationTwoPeriodsForbiddenNLP{(i,j) in Pumps, t in 0..(T-3)}: 
(cTwo + 1) * Q[i,j,t] + (cTwo - 1) * Q[i,j,t+1] + (cTwo - 1) * Q[i,j,t+2] + (cTwo + 1) * Q[i,j,t+3] >= 0;
s.t. PumpDeactivationOnePeriodForbiddenNLP{(i,j) in Pumps, t in 0..(T-2)}: Q[i,j,t+1] - cDeact * (Q[i,j,t] + Q[i,j,t+2] - sqrt((Q[i,j,t] - Q[i,j,t+2])^2 + alpha^2)) >= 0;
s.t. PumpDeactivationTwoPeriodsForbiddenNLP{(i,j) in Pumps, t in 0..(T-2)}: 
Q[i,j,t+1] - cDeact * (Q[i,j,t] + Q[i,j,t+3] - sqrt((Q[i,j,t] - Q[i,j,t+3])^2 + alpha^2)) >= 0;