# Standard Min-Cost-Flow Problem from Ahuja et al., Network Flows
# Specialized AMPL formulations for network models are not used in the examples
# Integrality of flows is required for demonstration purposes though integer flows are guaranteed for integral data!

set Nodes;
set Arcs within {Nodes, Nodes};

param Cost{Arcs};
param UpperCapacity{Arcs}; 
#Include general upper capacities but no lower ones. 
param SupplyDemand{Nodes} integer;		
#This parameter follows the convention > 0 for supply and < 0 for a demand

var ArcFlow{Arcs} >=0,  integer;	
#Zero lower bounds of flows in standard formulations. 
#Integrality requirement for demonstration purposes!

minimize FlowCost: sum{(i,j) in Arcs}(Cost[i,j] * ArcFlow[i,j]);

s.t. MassBalance{i in Nodes}: sum{(i,j) in Arcs}(ArcFlow[i,j]) - sum{(j,i) in Arcs}(ArcFlow[j,i]) = SupplyDemand[i];

s.t. UpperCapacityConstraints{(i,j) in Arcs}: ArcFlow[i,j] <= UpperCapacity[i,j]; 
