#General Min-Cost-Flow Model as it is traceable in the book of Ahuja et al., "Network Flows" till p. 650 ff. 

set Nodes;
set Arcs within {Nodes, Nodes};

# Split the commodities into continuous and integer ones in order to consider only some as indivisible goods. 
set ContinuousCommodities;
set IntegerCommodities; 

param Cost{Arcs, ContinuousCommodities union IntegerCommodities}; 
param LowerCapacity{Arcs}; 
param UpperCapacity{Arcs}; 
param mu{Arcs,ContinuousCommodities union IntegerCommodities} > 0; 
# mu is the multiplier to model loss and gain in arcs. If mu< 1 arcs are lossy. if mu > 1 they are gainy
param rho{Arcs,IntegerCommodities} >= 0; #parameter for inhomogeneous goods
param CommodityLowerCapacity{Arcs, ContinuousCommodities union IntegerCommodities};  
param CommodityUpperCapacity{Arcs, ContinuousCommodities union IntegerCommodities}; 
param SupplyDemandInteger{Nodes, IntegerCommodities} integer;	
param SupplyDemandContinuous{Nodes, ContinuousCommodities};		

var CommodityArcFlowContinuous{(i,j) in Arcs, k in ContinuousCommodities }; 
var CommodityArcFlowInteger{(i,j) in Arcs, k in IntegerCommodities } integer; 

minimize MultiCommodityFlowCost: sum{k in ContinuousCommodities}(sum{(i,j) in Arcs}(Cost[i,j,k] * CommodityArcFlowContinuous[i,j,k])) + sum{k in IntegerCommodities}(sum{(i,j) in Arcs}(Cost[i,j,k] * CommodityArcFlowInteger[i,j,k]));

s.t. ContinuousCommodityGeneralizedMassBalances{k in ContinuousCommodities, i in Nodes}: sum{(i,j) in Arcs}(CommodityArcFlowContinuous[i,j,k]) - sum{(j,i) in Arcs}(mu[j,i,k] * CommodityArcFlowContinuous[j,i,k]) = SupplyDemandContinuous[i,k];
s.t. IntegerCommodityGeneralizedMassBalances{k in IntegerCommodities, i in Nodes}: sum{(i,j) in Arcs}(CommodityArcFlowInteger[i,j,k]) - sum{(j,i) in Arcs}(mu[j,i,k] * CommodityArcFlowInteger[j,i,k]) = SupplyDemandInteger[i,k];

s.t. ResourceAvailabilityConstraintsUp{(i,j) in Arcs}: sum{k in ContinuousCommodities}(CommodityArcFlowContinuous[i,j,k]) + sum{k in IntegerCommodities}(rho[i,j,k] * CommodityArcFlowInteger[i,j,k])  <= UpperCapacity[i,j]; 
s.t. ResourceAvailabilityConstraintsLow{(i,j) in Arcs}: LowerCapacity[i,j] <= sum{k in ContinuousCommodities}(CommodityArcFlowContinuous[i,j,k]) + sum{k in IntegerCommodities}(rho[i,j,k] * CommodityArcFlowInteger[i,j,k]);

s.t. IndividualCommodityCapacityConstraintsContinuousUp{k in ContinuousCommodities, (i,j) in Arcs}: CommodityArcFlowContinuous[i,j,k] <= CommodityUpperCapacity[i,j,k];
s.t. IndividualCommodityCapacityConstraintsIntegerUp{k in IntegerCommodities, (i,j) in Arcs}: CommodityArcFlowInteger[i,j,k] <= CommodityUpperCapacity[i,j,k];
s.t. IndividualCommodityCapacityConstraintsContinuousLow{k in ContinuousCommodities, (i,j) in Arcs}: CommodityLowerCapacity[i,j,k] <= CommodityArcFlowContinuous[i,j,k];
s.t. IndividualCommodityCapacityConstraintsIntegerLow{k in IntegerCommodities, (i,j) in Arcs}: CommodityLowerCapacity[i,j,k] <= CommodityArcFlowInteger[i,j,k];