# Formulation follows Ahuja et al., Network Flows P. 649 ff.

set Nodes;
set Arcs within {Nodes, Nodes};
set Commodities;	
#Commodity-Set is new compared to the first min-cost-flow model.
#Parameters will be commodity dependent

param Cost{Arcs, Commodities}; 
param UpperCapacity{Arcs}; 
param CommodityUpperCapacity{Arcs, Commodities}; #New Individual Commodity Capacities!
param SupplyDemand{Nodes, Commodities} integer;		

var CommodityArcFlow{Arcs, Commodities} >= 0, integer ; 

minimize MultiCommodityFlowCost: sum{k in Commodities}(sum{(i,j) in Arcs}
(Cost[i,j,k] * CommodityArcFlow[i,j,k])); 
#Summation also over each Commodity

s.t. CommodityMassBalances{k in Commodities, i in Nodes}: sum{(i,j) in Arcs}(CommodityArcFlow[i,j,k]) - sum{(j,i) in Arcs}(CommodityArcFlow[j,i,k]) = SupplyDemand[i,k];
#Additional indexing for Commodities

s.t. BundleConstraints{(i,j) in Arcs}: sum{k in Commodities}(CommodityArcFlow[i,j,k]) <= UpperCapacity[i,j];
#Arc Flow Bounds extended to a sum over all Commodities

s.t. IndividualCommodityCapacityConstraintsUp{k in Commodities, (i,j) in Arcs}: CommodityArcFlow[i,j,k] <= CommodityUpperCapacity[i,j,k];
#New Bounding Constraints that are individual for every Commodity

