package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class ArcSetDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		String[] varnames = {"setarc", "nonInstantiable", "setnode", "unionsetoperandsnode", "unionsetoperandnames"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
				for(String entityname:entitiesandNames.get("setarc")){
					
					//TODO: If Noninstantiable break the actual iteration with continue!
					boolean noninst = data.containsNonInstantiabilityTrueInformation(entityname, "setarc", "nonInstantiable");
					if (noninst == true){continue;}
					
					//System.out.println("Heres the number of model entities for ArcSet to derive:" + entitiesandNames.get("setnode").size());
					
					//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
					Element literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, EntityKind.set);
					literal.setText(entityname);
					Element statementtypetag = literal.getParentElement().getParentElement();
					
					
					//Treatment of optional within!
					//For simplicity we only implemen a single withincartproducttwosame in this type! No generous helper method!
					
					//Let the following be generous
					List<String> withinvarnames = new LinkedList();
					withinvarnames.add("setnode");
					Hashtable<String, Set<String>> entsandvarnames = data.getEntitiesandNamesforVariables(withinvarnames);
					//Quick and dirty
					Iterator<String> indexiter = entsandvarnames.get("setnode").iterator();
					
					if(indexiter.hasNext()){
						
						String withinstringname = indexiter.next();
						
						Element sattributes = new Element("s_attributes");
						statementtypetag.addContent(sattributes);
						
						Element sattribute = new Element("s_attribute");
						sattributes.addContent(sattribute);
						
						Element within = new Element("WITHIN");
						within.setText("within");
						sattribute.addContent(within);
						
						Element wsexpr = new Element("sexpr");
						sattribute.addContent(wsexpr);
						
						Element lid = new Element("id");
						Element llit = new Element("LITERAL");
						wsexpr.addContent(lid);
						lid.addContent(llit);
						llit.setText(withinstringname);
						
						Element soperator = new Element("soperator");
						wsexpr.addContent(soperator);
						Element cross = new Element("CROSS");
						cross.setText("cross");
						soperator.addContent(cross);
						
						Element rid = new Element("id");
						Element rlit = new Element("LITERAL");
						wsexpr.addContent(rid);
						rid.addContent(rlit);
						rlit.setText(withinstringname);
						
					}
					
					
					//Semikolon
					Element semikolon = new Element("SEMIKOLON");
					semikolon.setText(";");
					statementtypetag.addContent(semikolon);
					
					//?Enter a breakline into the document: Not here, xslt for string representation should match the ';' character.
				}
		
		return doc;
	}

}
