package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class CommoditySetDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		String[] varnames = {"setcommodity", "nonInstantiable"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		
		// Loop over every model entity of the type
				for(String entityname:entitiesandNames.get("setcommodity")){
					//System.out.println("Heres the number of model entities for NodeSet to derive:" + entitiesandNames.get("setnode").size());
					
					//If Noninstantiable break the actual iteration with continue!
					boolean noninst = data.containsNonInstantiabilityTrueInformation(entityname, "setcommodity", "nonInstantiable");
					if (noninst == true){continue;}
					
					//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
					Element literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, EntityKind.set);
					literal.setText(entityname);
					Element statementtypetag = literal.getParentElement().getParentElement();

					
					//Semikolon
					Element semikolon = new Element("SEMIKOLON");
					semikolon.setText(";");
					statementtypetag.addContent(semikolon);

				}
		
		return doc;
	}

}
