package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class LinearMultipleCommoditySetsFlowCostGoalDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		
		// Retrieve the results and entities and names for all interesting variables 
		String[] varnames = {"forment", "setarc", "unionsetoperandsarc", "unionsetoperandnamesarc", "varparcost", "expcomcostflowsumiri", "setcom", "unionsetoperandscom", "unionsetoperandnamescom", "varparflow"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("forment")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.objectivemin;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			
			//Get back the objective tag
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			//Suppress indexing for objectives! --> No Indexing here
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Expression with Indexing Helpers
			Element oexpr = new Element("oexpr");
			statementtypetag.addContent(oexpr);
			Element outersumexpr = new Element("expr");
			oexpr.addContent(outersumexpr);
			
			//Start the iterative generation of summands
			
			//Always keep a last expression
			Element lastexpr = outersumexpr;
			//First call to helper for continuous commodities
			
			Collection<String> expressions = data.returnMultipleRelatedEntitiesNamesforEntityName(entityname, "expcomcostflowsumiri");
			Iterator<String> it = expressions.iterator();
			
			//Commodity-Set Indexing helpers are constructed outside the following loop since they don't vary
			String[] indexvarnamescom = {"setcom"};
			Hashtable<String,String> unionsetindexvarnamescom = new Hashtable<String,String>();
			unionsetindexvarnamescom.put("setcom","unionsetoperandnamescom");
			Hashtable<String,String[]> indexvarnamedummiescom = new Hashtable<String,String[]>();
			String[] kind = {"k"}; 
			indexvarnamedummiescom.put("setcom", kind);
			
			//The same goes for the Arc-Set Indexing Helpers:
			String[] indexvarnamesarc = {"setarc"};
			Hashtable<String,String> unionsetindexvarnamesarc = new Hashtable<String,String>();
			unionsetindexvarnamesarc.put("setarc","unionsetoperandnamesarc");
			Hashtable<String,String[]> indexvarnamedummiesarc = new Hashtable<String,String[]>();
			String[] ijinds = {"i","j"}; 
			indexvarnamedummiesarc.put("setarc", ijinds);
			
			//Need a loop that adds an add expression pair for every summand!
			while (it.hasNext()){
				
				String expressioniri = it.next();
				
				//Retrieve Parameter Data: Name and dummy indices
				String goodmultname = data.returnRelatedEntityNameforEntityName(expressioniri, "varparcost");
				String[] ijkinds = {"i","j","k"}; 
				//Retrieve Variable Data
				String flowname = data.returnRelatedEntityNameforEntityName(expressioniri, "varparflow");
			
				//Build Sum-Expression by helper call, set-info is retrieved within call
				//TODO: Check that parameterizing with expressioniri for the entityname really leads to an indexing with the correct commodity-sets. In the
				//examples, this works an I even think it is correct :-)
				MyAMPLStatementXMLStructureHelper.insertTwoNestedSumsParamVarPairSummationExpression(lastexpr, expressioniri, goodmultname, ijkinds, flowname, ijkinds, data, entitiesandNames, indexvarnamescom, unionsetindexvarnamescom, indexvarnamedummiescom,indexvarnamesarc, unionsetindexvarnamesarc, indexvarnamedummiesarc);
			
				//If there is another Element comming, add a plus and an extra expression? Change Loop-Collection type or use an iterator?
				if(it.hasNext()){
				
					//New Plus
					Element aoper = new Element("aoperator_low");
					Element pls = new Element("PLUS");
					pls.setText("+");
					aoper.addContent(pls);
					lastexpr.addContent(aoper);
				
					//Add next Expression Element
					Element nextexpr = new Element("expr");
					lastexpr.addContent(nextexpr);
					lastexpr = nextexpr;
				}
			
			}
			
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);
	
		}
				
		return doc;
	}

}