package de.dsor.ontooptmod.derivation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

import de.dsor.ontooptmod.helpers.Pair;

/**
 * This class provides static helper methods for generating parts of xml-trees that represent AMPL-models. It is used for the statement derivation process
 * TODO: An OOD Improvement would be to use this class as an (abstrac) superclass for the IEntityTypeStatementDerivation implementing classes
 * and therefore provide these helpers in a dynamic way without exchanging to much data. E.g., the SPARQLResult structures could be kept in this class.
 * Check: Template-Method Pattern for this!
 * @author Florian Stapel
 *
 */
public class MyAMPLStatementXMLStructureHelper {

	/*
	 * Kind of static factory method that creates a document for AMPL Statements
	 */
	public static Document createStatementDerivationDocument(){
		//TODO: Go on herer create the root element with the major namespace definitions. Optionally support the generation of n statement nodes.
		Element root = new Element("root");
		
		//The following loc does not work and we don't need that here. Better would be using a namespace for the AMPL / XML Representation
		//root.setAttribute("xmlns:sres","http://www.w3.org/2005/sparql-results#");
		Document doc = new Document(root);
		
		return doc;
	}
	
	/**
	 * This method enters some nodes into the document that represent the basic structure of a statement representing a model entity.
	 * The kind of the model entitiy, i.e., set, parameter, variable, constriant, etc., will be used as a tag Name and representing AMPL keyword.
	 * The Document will contain the nodes for the keyword and some nodes representing the identifying LITERAL. Further processing after the method
	 * call will have to insert the indentifier of the LITERAL. The returne Element corresponds to the literal node into which an identifier has to be entered.
	 * @param doc
	 * @param entkind
	 * @return
	 */
	public static Element insertStatementwithEntity(Document doc, EntityKind entkind){
		
		//Root Element and Statement Node
		Element root = doc.getRootElement();
		Element statement = new Element("statement");
		root.addContent(statement);
		
		//Model Entity Node
		Element modent = new Element("mod_entity");
		statement.addContent(modent);
		
		//EntityStatementNode
		Element entstatementnode = new Element(returnStatementTagNameforEntityKind(entkind));
		modent.addContent(entstatementnode);
		
		//EntityKindNode
		Pair<String,String> entitykindinformation = returnTagNameandTextforEntityKind(entkind);
		Element entkindnode = new Element(entitykindinformation.getFirst());
		entkindnode.setText(entitykindinformation.getSecond());
		entstatementnode.addContent(entkindnode);
		
		//Id and Literal Node
		Element id = new Element("id");
		Element literal = new Element("LITERAL");
		entstatementnode.addContent(id);
		id.addContent(literal);
		
	
		//Return the reference to the literal node
		return literal;
	}

	
	//Implementation and Comment To Do
	//Indexvarnamedummies: every index variable get's different result entities for multiple statements but will always be implemented with the same dummy indices. 
	//Dummy indices can be multi-dimensional. Hence, besides "i" or "j", "(i,j)" is also a valid string argument. 
public static Element insertIndexing(Element parenttag, String entname, IModelQueryIndividualsStructure resultsstruct, Hashtable<String,Set<String>> entitiesandNames, String[] indexvarnames, Hashtable<String, String> unionoperandsnamesvarnames, Hashtable<String,String[]> indexvarnamedummies){
		
		//Compute indexes and return without an effect it there is no indexing:loop over all indexvarname results
		//TODO: Actual problem: We get to many indexes. Only the ones for the current entity are of interest (helper vs. case in this method)
		//TODO: Actual problem: indexvarnames don't match indexnames. Need to store them together!
		Hashtable<String, String> indexvarsandnames = new Hashtable<String, String>();
		for(String indvar:indexvarnames){
			indexvarsandnames.put(indvar, resultsstruct.returnRelatedEntityNameforEntityName(entname, indvar));
		}
		
		//TODO: Check the following for correctness
		Collection<String> indexnames = indexvarsandnames.values();
		//Break if there are no indexes
		if(indexnames.isEmpty()) return parenttag;
		System.out.println("Here come some index names: " + indexnames.toString());
		
		//Generate indexing tag
		Element indexing = new Element("indexing");
		parenttag.addContent(indexing);
		
		//Generate opening curled braces
		Element lcurlbr = new Element("LCURLBRACKET");
		lcurlbr.setText("{");
		indexing.addContent(lcurlbr);
		
		//Generate sexpr-list and content for every index
		Element sexprlist = new Element("sexpr_list");
		indexing.addContent(sexprlist);
		
		//Loop over every Index. In order to keep everything in the right order we need to loop over every variable first and then the indexes for that
		//TODO: INDEXES WITH DUMMY INDICES
		for(int i=0; i< indexvarnames.length; i++){
			
			String indname = indexvarsandnames.get(indexvarnames[i]);
			
				//Inser dummymembersin only if there is a dummymember-indexing
				if(indexvarnamedummies.get(indexvarnames[i]).length >= 1){
				//TODO Change here an generate the sequence dummymembers in sexpr
				Element dummymembers = new Element("dummymembers");
				sexprlist.addContent(dummymembers);
				MyAMPLStatementXMLStructureHelper.insertDummyMembers(dummymembers, indexvarnamedummies.get(indexvarnames[i]));
				
				//Add in-element
				Element in = new Element("IN");
				in.setText("in");
				sexprlist.addContent(in);
				}
				
				//Generate sexpr-node
				Element sexpr = new Element("sexpr");
				sexprlist.addContent(sexpr);
		
				//Check for UnionSetDefinitions. Problem: We need the name of the query variable for the current union set of the index!
				List<String> unionsetoperands = resultsstruct.getUnionSetOperandsinCaseOfUnionSet(indname, indexvarnames[i], unionoperandsnamesvarnames.get(indexvarnames[i]));
				
				//TODO Case1: No unionset: ename
				//TODO:In the example this one is still activated for unionarcset
				if(unionsetoperands == null || unionsetoperands.isEmpty()){
					//Generate id-node
					System.out.println("Processing name of a non-unionset indice:" + indname);
					Element id = new Element("id");
					sexpr.addContent(id);
					Element literal = new Element("LITERAL");
					id.addContent(literal);
					literal.setText(indname);	
				}
				//TODO Case2: Process a unionset. Union Operator only if there is a next Element
				if(unionsetoperands.size() >= 1){
					
					Element lowersexpr = new Element("sexpr");
					sexpr.addContent(lowersexpr);
					Iterator<String> iter = unionsetoperands.iterator();
					Element lastsexprforid = lowersexpr;
					
					while(iter.hasNext()){
					   
						//Generate the operand. Need a sexpr
						Element id = new Element("id");
						sexpr.addContent(id);
						Element literal = new Element("LITERAL");
						id.addContent(literal);
						literal.setText(iter.next());	
					
						//Add union and sexpr keyword for the next element
						if(iter.hasNext()){
							//Union
							Element soperator = new Element("soperator");
							sexpr.addContent(soperator);
							Element union = new Element("UNION");
							union.setText("union");
							soperator.addContent(union);
							
							//sexpr
							Element nextsexpr = new Element("sexpr");
							sexpr.addContent(nextsexpr);
							//lastsexpr
							lastsexprforid = nextsexpr;
						}
					}
				}
				
				//Indice Commata only if there is a next element
				//TODO: Test and Debug!
				if(i < indexvarnames.length - 1){
					Element comma = new Element("COMMA");
					comma.setText(",");
					sexprlist.addContent(comma);
				}
		}
		
		//Generate closing curled braces
		Element rcurlbr = new Element("RCURLBRACKET");
		rcurlbr.setText("}");
		indexing.addContent(rcurlbr);
		
		return parenttag;
	}
	
	/**
	 * TODO
	 * @param dummymemberstag
	 * @param dummyindices
	 */
	private static void insertDummyMembers(Element dummymemberstag, String[] dummyindices) {
		if(dummyindices.length < 1){System.err.println("Called insertDummyMembers without a single dummy-indices");}
		
		//Generate the first dummy-member
		Element firstdummymember = new Element("dummymember");
		Element firstid = new Element("id");
		Element firstlit = new Element("LITERAL");
		firstlit.setText(dummyindices[0]);
		firstid.addContent(firstlit);
		firstdummymember.addContent(firstid);
		
		//Simple production and return if there is only one dummy-indice
		if(dummyindices.length ==1){dummymemberstag.addContent(firstdummymember); return;}
		
		//More complicated case with brackets
		else{
		
		Element lroundbr = new Element("LROUNDBRACKET");
		lroundbr.setText("(");
		dummymemberstag.addContent(lroundbr);
		
		dummymemberstag.addContent(firstdummymember);
		
		int dummyindicepos = 1;
		
		Element lastdummyseq = null;
		
		if(dummyindicepos < dummyindices.length){lastdummyseq = new Element("dummymember_sequence");
		dummymemberstag.addContent(lastdummyseq);}
		
		while(dummyindicepos < dummyindices.length){
			
			//Generate comma
			Element comma = new Element("COMMA");
			comma.setText(",");
			lastdummyseq.addContent(comma);
			
			//Generate next dummy-indice
			Element nextdummymember = new Element("dummymember");
			Element nextid = new Element("id");
			Element nextlit = new Element("LITERAL");
			nextlit.setText(dummyindices[dummyindicepos]);
			nextid.addContent(nextlit);
			nextdummymember.addContent(nextid);
			lastdummyseq.addContent(nextdummymember);
			
			//Increase Position				
			dummyindicepos +=1;
			
			//Producenext sequence if required
			if(dummyindicepos < dummyindices.length){
			Element nextdummyseq = new Element("dummymember_sequence");
			lastdummyseq.addContent(nextdummyseq);
			lastdummyseq = nextdummyseq;
			}
		}
		
		Element rroundbr = new Element("RROUNDBRACKET");
		rroundbr.setText(")");
		dummymemberstag.addContent(rroundbr);
		}
		
	}
	
	public static void insertMultipleIndexSetsParamVarPairSummationExpression(Element fatherexpr, String entityname, String litnameparam, String[] subscriptindicesparam, String litnamevar, String[] subscriptindicesvar, IModelQueryIndividualsStructure data, Hashtable<String,Set<String>> entitiesandNames, String[] indexvarnames, Hashtable<String, String> unionoperandsnamesvarnames, Hashtable<String,String[]> indexvarnamedummies){
		
		//Generate expr
		Element expr = new Element("expr");
		fatherexpr.addContent(expr);
		
		//ropertor Sum  with a generous indexing. 
		Element roperator= new Element("roperator");
		Element sum= new Element("SUM");
		sum.setText("sum");
		roperator.addContent(sum);
		expr.addContent(roperator);
		
		//Indexing of Summation
		MyAMPLStatementXMLStructureHelper.insertIndexing(expr, entityname, data, entitiesandNames, indexvarnames, unionoperandsnamesvarnames, indexvarnamedummies);
		
		//The argument Expression
		Element argexpr = new Element("expr");
		expr.addContent(argexpr);
		
		
		//Left brackets
		Element lrb = new Element("LROUNDBRACKET");
		lrb.setText("(");
		argexpr.addContent(lrb);
		
		//The expr in the brackets
		Element mulexpr = new Element("expr");
		argexpr.addContent(mulexpr);
		
		
		//MulExpression of Var and Param
		//Param Content
		MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, litnameparam, subscriptindicesparam);
		
		//Generate aoperator
		Element aoper = new Element("aoperator_high");
		Element mul = new Element("MUL");
		mul.setText("*");
		aoper.addContent(mul);
		mulexpr.addContent(aoper);
		
		//Generate right expr content for var
		MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, litnamevar, subscriptindicesvar);
	
		
		//Right Brackets
		Element rrb = new Element("RROUNDBRACKET");
		rrb.setText(")");
		argexpr.addContent(rrb);
		
	}
	
public static void insertTwoNestedSumsParamVarPairSummationExpression(Element fatherexpr, String entityname, String litnameparam, String[] subscriptindicesparam, String litnamevar, String[] subscriptindicesvar, IModelQueryIndividualsStructure data, Hashtable<String,Set<String>> entitiesandNames, String[] indexvarnamesOuterSum, Hashtable<String, String> unionoperandsnamesvarnamesOuterSum, Hashtable<String,String[]> indexvarnamedummiesOuterSum, String[] indexvarnamesInnerSum, Hashtable<String, String> unionoperandsnamesvarnamesInnerSum, Hashtable<String,String[]> indexvarnamedummiesInnerSum){
		
		//Generate expr
		Element expr = new Element("expr");
		fatherexpr.addContent(expr);
		
		//ropertor Sum  with a generous indexing. 
		Element roperator= new Element("roperator");
		Element sum= new Element("SUM");
		sum.setText("sum");
		roperator.addContent(sum);
		expr.addContent(roperator);
		
		//Indexing of Summation
		MyAMPLStatementXMLStructureHelper.insertIndexing(expr, entityname, data, entitiesandNames, indexvarnamesOuterSum, unionoperandsnamesvarnamesOuterSum, indexvarnamedummiesOuterSum);
		
		//The argument Expression
		Element argexpr = new Element("expr");
		expr.addContent(argexpr);
		
		
		//Left brackets
		Element lrb = new Element("LROUNDBRACKET");
		lrb.setText("(");
		argexpr.addContent(lrb);
		
		
		//TODO: Overwork this to an inner sum
		Element innersumexpr = new Element("expr");
		argexpr.addContent(innersumexpr);
		
		Element roperatortwo= new Element("roperator");
		Element sumtwo= new Element("SUM");
		sumtwo.setText("sum");
		roperatortwo.addContent(sumtwo);
		innersumexpr.addContent(roperatortwo);
		
		//Indexing of inner Summation
		MyAMPLStatementXMLStructureHelper.insertIndexing(innersumexpr, entityname, data, entitiesandNames, indexvarnamesInnerSum, unionoperandsnamesvarnamesInnerSum, indexvarnamedummiesInnerSum);
		
		//The expression for the inner sum: Brackets
		Element innersumbrackexp = new Element("expr");
		innersumexpr.addContent(innersumbrackexp);
		
		
		//Left brackets
		Element lrbtwo = new Element("LROUNDBRACKET");
		lrbtwo.setText("(");
		innersumbrackexp.addContent(lrbtwo);
		
		
		//Add content to inner sum expr
		Element mulexpr = new Element("expr");
		innersumbrackexp.addContent(mulexpr);
		
		//MulExpression of Var and Param
		//Param Content
		MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, litnameparam, subscriptindicesparam);
		
		//Generate aoperator
		Element aoper = new Element("aoperator_high");
		Element mul = new Element("MUL");
		mul.setText("*");
		aoper.addContent(mul);
		mulexpr.addContent(aoper);
		
		//Generate right expr content for var
		MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(mulexpr, litnamevar, subscriptindicesvar);
		
		//Left brackets
		Element rrbtwo = new Element("RROUNDBRACKET");
		rrbtwo.setText(")");
		innersumbrackexp.addContent(rrbtwo);
				
		
		//Right Brackets
		Element rrb = new Element("RROUNDBRACKET");
		rrb.setText(")");
		argexpr.addContent(rrb);
		
	}
	
	public static void insertSimpleOneVarSummationExpression(Element fatherexpr, String entityname, String litname, String[] subscriptindices, IModelQueryIndividualsStructure data, Hashtable<String,Set<String>> entitiesandNames, String[] indexvarnames, Hashtable<String, String> unionoperandsnamesvarnames, Hashtable<String,String[]> indexvarnamedummies){
		
		//Generate expr
		Element expr = new Element("expr");
		fatherexpr.addContent(expr);
		
		//ropertor Sum  with a generous indexing. 
		Element roperator= new Element("roperator");
		Element sum= new Element("SUM");
		sum.setText("sum");
		roperator.addContent(sum);
		expr.addContent(roperator);
		
		//Indexing of Summation
		MyAMPLStatementXMLStructureHelper.insertIndexing(expr, entityname, data, entitiesandNames, indexvarnames, unionoperandsnamesvarnames, indexvarnamedummies);
		
		//The argument Expression
		Element argexpr = new Element("expr");
		expr.addContent(argexpr);
		
		
		//Left brackets
		Element lrb = new Element("LROUNDBRACKET");
		lrb.setText("(");
		argexpr.addContent(lrb);
		
		//The expr in the brackets
		Element varexpr = new Element("expr");
		argexpr.addContent(varexpr);
		
		//Generate expr content for Flow
		MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(varexpr, litname, subscriptindices);
	
		
		//Right Brackets
		Element rrb = new Element("RROUNDBRACKET");
		rrb.setText(")");
		argexpr.addContent(rrb);
		
	}

	
	public static void insertVarParwithSubscript(Element father, String litname, String[] subscriptindices){
	
		//Create a new Expression and add it under the father
		Element expr = new Element("expr");
		father.addContent(expr);
		
		//Insert the varpar-name
		Element id = new Element("id");
		Element literal = new Element("LITERAL");
		literal.setText(litname);
		id.addContent(literal);
		expr.addContent(id);
		
		//Create the subscript and insert it
		Element subscript = new Element("subscript");
		expr.addContent(subscript);
		
		//Brackets left
		Element lsqb = new Element("LSQBRACKET");
		lsqb.setText("[");
		subscript.addContent(lsqb);
		
		//Elements separated by commata directly under the subscript node in order 
		int subscriptcount = 0;
		while(subscriptcount < subscriptindices.length){
			
			//Insert the Elements
			Element el = new Element("element");
			Element ellit = new Element("LITERAL");
			ellit.setText(subscriptindices[subscriptcount]);
			el.addContent(ellit);
			subscript.addContent(el);
			
			subscriptcount +=1;
			
			if(subscriptcount < subscriptindices.length){
				Element comma = new Element("COMMA");
				comma.setText(",");
				subscript.addContent(comma);
			}
		}
		
		//Brackets right
		Element rsqb = new Element("RSQBRACKET");
		rsqb.setText("]");
		subscript.addContent(rsqb);
		
		
	}
	
	/**
	 * This method inserts an indexing element under a statementtype-tag. The indexing only has setnames and is separated by commata. Unionsets are supported.
	 *  For general indexings that allow for dummymember in set expressions and can be put under general expressions, call the more general insertIndexing.
	 *  This method returns the statementtypetag under which the indexing has been inserted.
	 * @param statementtypetag
	 * @param entname
	 * @param resultsstruct
	 * @param entitiesandNames
	 * @param indexvarnames
	 * @param unionoperandsnamesvarnames
	 * @return
	 */
	public static Element insertSimpleIndexing(Element statementtypetag, String entname, IModelQueryIndividualsStructure resultsstruct, Hashtable<String,Set<String>> entitiesandNames, String[] indexvarnames, Hashtable<String, String> unionoperandsnamesvarnames){
		
		//Compute indexes and return without an effect it there is no indexing:loop over all indexvarname results
		//TODO: Actual problem: We get to many indexes. Only the ones for the current entity are of interest (helper vs. case in this method)
		//TODO: Actual problem: indexvarnames don't match indexnames. Need to store them together!
		Hashtable<String, String> indexvarsandnames = new Hashtable<String, String>();
		for(String indvar:indexvarnames){
			indexvarsandnames.put(indvar, resultsstruct.returnRelatedEntityNameforEntityName(entname, indvar));
		}
		
		//TODO: Check the following for correctness
		Collection<String> indexnames = indexvarsandnames.values();
		//Break if there are no indexes
		if(indexnames.isEmpty()) return statementtypetag;
		System.out.println("Here come some index names: " + indexnames.toString());
		
		//Generate indexing tag
		Element indexing = new Element("indexing");
		statementtypetag.addContent(indexing);
		
		//Generate opening curled braces
		Element lcurlbr = new Element("LCURLBRACKET");
		lcurlbr.setText("{");
		indexing.addContent(lcurlbr);
		
		//Generate sexpr-list and content for every index
		Element sexprlist = new Element("sexpr_list");
		indexing.addContent(sexprlist);
		
		//Loop over every Index. In order to keep everything in the right order we need to loop over every variable first and then the indexes for that
		//TODO: Indexes in order
		for(int i=0; i< indexvarnames.length; i++){
			
			String indname = indexvarsandnames.get(indexvarnames[i]);
			
				//Generate sexpr-node
				Element sexpr = new Element("sexpr");
				sexprlist.addContent(sexpr);
		
				//Check for UnionSetDefinitions. Problem: We need the name of the query variable for the current union set of the index!
				List<String> unionsetoperands = resultsstruct.getUnionSetOperandsinCaseOfUnionSet(indname, indexvarnames[i], unionoperandsnamesvarnames.get(indexvarnames[i]));
				
				//TODO Case1: No unionset: ename
				//TODO:In the example this one is still activated for unionarcset
				if(unionsetoperands == null || unionsetoperands.isEmpty()){
					//Generate id-node
					System.out.println("Processing name of a non-unionset indice:" + indname);
					Element id = new Element("id");
					sexpr.addContent(id);
					Element literal = new Element("LITERAL");
					id.addContent(literal);
					literal.setText(indname);	
				}
				//TODO Case2: Process a unionset. Union Operator only if there is a next Element
				if(unionsetoperands.size() >= 1){
					
					Element lowersexpr = new Element("sexpr");
					sexpr.addContent(lowersexpr);
					Iterator<String> iter = unionsetoperands.iterator();
					Element lastsexprforid = lowersexpr;
					
					while(iter.hasNext()){
					   
						//Generate the operand. Need a sexpr
						Element id = new Element("id");
						sexpr.addContent(id);
						Element literal = new Element("LITERAL");
						id.addContent(literal);
						literal.setText(iter.next());	
					
						//Add union and sexpr keyword for the next element
						if(iter.hasNext()){
							//Union
							Element soperator = new Element("soperator");
							sexpr.addContent(soperator);
							Element union = new Element("UNION");
							union.setText("union");
							soperator.addContent(union);
							
							//sexpr
							Element nextsexpr = new Element("sexpr");
							sexpr.addContent(nextsexpr);
							//lastsexpr
							lastsexprforid = nextsexpr;
						}
					}
				}
				
				//Indice Commata only if there is a next element
				//TODO: Test and Debug!
				if(i < indexvarnames.length - 1){
					Element comma = new Element("COMMA");
					comma.setText(",");
					sexprlist.addContent(comma);
				}
		}
		
		//Generate closing curled braces
		Element rcurlbr = new Element("RCURLBRACKET");
		rcurlbr.setText("}");
		indexing.addContent(rcurlbr);
		
		return statementtypetag;
	}
	
	
	
	public static void insertMPropsforEntity(Element statementtypetag, String entname, String entvarname, EntityKind entkind, IModelQueryIndividualsStructure data){
		
		Element attributes = null;
		if(entkind == EntityKind.param){attributes = new Element("p_attributes");}
		else{attributes = new Element("v_attributes");}
		
		int mpropcount = 0;
		
		// To Do: Multiple attributes with commata. Insert the nodes only if there was an MProp
		for(MProp mprop:MProp.values()){
			//Check wether we need to instantiate the mprop for the entity
			if(!data.containsMPropforEntity(entname, entvarname, mprop).booleanValue()){continue;}
			
			//Count the generated MProps
			System.out.println("Going to instantiate an MProp:" + mprop);
			mpropcount += 1;
			
			//To Do: Add commata only if needed
			if(mpropcount >= 2){
			Element comma = new Element("COMMA");
			comma.setText(",");
			attributes.addContent(comma);
			}
			
			//Generate the next Attribute with it's content
			Element attribute = null;
			if(entkind == EntityKind.param){attribute = new Element("p_attribute");}
			else{attribute = new Element("v_attribute");}
			
			Element nodebelowattribute = MyAMPLStatementXMLStructureHelper.returnLowerElementsandContentforMProp(mprop);
			attribute.addContent(nodebelowattribute);
			attributes.addContent(attribute);
					
		}
		
		//Check whether there is at least one MProp and insert node!
		if(mpropcount >= 1){statementtypetag.addContent(attributes);}
	}
	
	public static Element returnLowerElementsandContentforMProp(MProp mprop){
		Element el = null;
				
				switch(mprop){
				case LBZeroEQ:  el = new Element("RANGEEXP");
				Element gt = new Element("GT");
				gt.setText(">=");
				Element numbervalone = new Element("NUMBER");
				numbervalone.setText("0.0");
				el.addContent(gt);
				el.addContent(numbervalone);
				return el;
				
				case LBZeroSPos: el = new Element("RANGEEXP");
				Element g = new Element("G");
				g.setText(">");
				Element numbervaltwo = new Element("NUMBER");
				numbervaltwo.setText("0.0");
				el.addContent(g);
				el.addContent(numbervaltwo);
				return el;
				
				case IntegerProp: el = new Element("INTEGER") ;
				el.setText("integer");
				return el;
				
				case BinaryProp: el = new Element("BINARY") ;
				el.setText("binary");
				return el;
				
				default: System.err.println("Not Able to generate Node Content for mprop " + mprop);
				break;
				}
				
		return el;
	}
	/**
	 * The name says what this method does!
	 * @param entkind
	 * @return
	 */
	public static String returnStatementTagNameforEntityKind(EntityKind entkind){
		String resultval = null;
		
		switch(entkind){
		case set: resultval = "set";
			break;
		case param: resultval = "param";
			break;
		case var: resultval =  "var";
			break;
		case objectivemin: resultval = "objective"; 
			break;
		case objectivemax: resultval = "objective";
			break;
		case constraint: resultval = "constraint";
			break;
		default: System.err.println("Mistake when trying to find the statement tag name for the entity kind: " + entkind);
		 	break;	
		}
	    return resultval;
	}
	
	/**
	 * The name says what this method does!
	 * @param entkind
	 * @return
	 */
	public static Pair<String,String> returnTagNameandTextforEntityKind(EntityKind entkind){
		Pair<String,String> resultval = null;
		
		switch(entkind){
		case set: resultval = new Pair<String,String>("SET", "set");
			break;
		case param: resultval = new Pair<String,String>("PARAM", "param");
			break;
		case var: resultval =  new Pair<String,String>("VAR", "var");
			break;
		case objectivemin: resultval = new Pair<String,String>("MAXIMIZE", "minimize");
			break;
		case objectivemax: resultval = new Pair<String,String>("MINIMIZE", "maximize");
			break;
		case constraint: resultval = new Pair<String,String>("SUBTO", "s.t.");
			break;
		default: System.err.println("Mistake when trying to find the tagnames and text for the entity kind: " + entkind);
		 	break;	 
		}
		
		return resultval;
	}
	
}
