package de.dsor.ontooptmod.derivation;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.jdom2.Document;
import org.jdom2.Element;

public class SingleCommodityFlowBoundsUpDerivation implements IEntityTypeStatementDerivation {

	@Override
	public Document deriveStatements(IModelQueryIndividualsStructure data) {
		
		// Generate Document by call to factory method
		Document doc = MyAMPLStatementXMLStructureHelper.createStatementDerivationDocument();
		
		// Retrieve the results and entities and names for all interesting variables
		String[] varnames = {"forment", "setarc", "unionsetoperandsarc", "unionsetoperandnames", "varparcap", "varparflow"};
		Hashtable<String,Set<String>> entitiesandNames = data.getEntitiesandNamesforVariables(Arrays.asList(varnames));
		
		// Loop over every model entity of the type
		for(String entityname:entitiesandNames.get("forment")){
			//System.out.println("Heres the number of model entities for SingleCommodityFlowCollection to derive:" + entitiesandNames.get("parvarflow").size());
			
			//Setting the literature content (identifier). Keyword has already been generated. Also retrieve the statement-type tag
			//Configure with variable or parameter, depending on what has been specified!
			Element literal = null;
			EntityKind entkind = EntityKind.constraint;
			
			literal = MyAMPLStatementXMLStructureHelper.insertStatementwithEntity(doc, entkind);
			
			literal.setText(entityname);
			Element statementtypetag = literal.getParentElement().getParentElement();
			
			
			
			//Indexing with dummy indices
			String[] indexvarnames = {"setarc"};
			Hashtable<String,String> unionsetindexvarnames = new Hashtable<String,String>();
			unionsetindexvarnames.put("setarc","unionsetoperandnames");
			Hashtable<String,String[]> indexvarnamedummies = new Hashtable<String,String[]>();
			String[] ijinds = {"i" , "j"}; 
			indexvarnamedummies.put("setarc", ijinds);
			MyAMPLStatementXMLStructureHelper.insertIndexing(statementtypetag, entityname, data, entitiesandNames, indexvarnames, unionsetindexvarnames, indexvarnamedummies);
			
			//Colon
			Element colon = new Element("COLON");
			colon.setText(":");
			statementtypetag.addContent(colon);
			
			//Constraint-Exression
			Element cexpr = new Element("cexpr");
			statementtypetag.addContent(cexpr);
			
			//Generate left expr content for Flow
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(cexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparflow"), ijinds);
			
			//Generate LT
			Element lt = new Element("LT");
			lt.setText("<=");
			cexpr.addContent(lt);
			
			//Generate right expr content for Cap
			MyAMPLStatementXMLStructureHelper.insertVarParwithSubscript(cexpr, data.returnRelatedEntityNameforEntityName(entityname, "varparcap"), ijinds);
			
			//Semikolon
			Element semikolon = new Element("SEMIKOLON");
			semikolon.setText(";");
			statementtypetag.addContent(semikolon);

		}
				
		return doc;
	}

}