package de.dsor.ontooptmod.derivation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;

import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;

import org.jdom2.*;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.*;
import org.jdom2.input.SAXBuilder;

import de.dsor.ontooptmod.helpers.*;



/**
 * This class provides functionality to manage a statement derivation process that transforms ontology optimization model representations into AML statements and whole models.
 * @author Florian Stapel
 *
 */
public class StatementDerivationManager {
	
	private String currentAMLString;
	private StatementDerivationService derivationService;
	
	/**
	 * Constructor performs initializations of AML-string and the derivation "service"
	 */
	public StatementDerivationManager(){
		this.currentAMLString = "";
		this.derivationService = new StatementDerivationService();
	}
	
	/*
	 * This method of the StatementDerivationManager performs a call to a statement derivation service implemented in (CLASS IS TO DO).
	 * Since the latter is a service method, it has not state and simply returns an xml document. Therefore the method below will not only perform the call 
	 * but also manage the storage of results on the file-system and actualize the current AML String for the system.
	 */
	public void DelegateCalltoDerivationService(String formulationTypeString, File xmlqueryresultsinput, File xmlresultloc ){
		
		//Load Input XML from File-Sytem
		Document xmlinput = null;

		try {
				xmlinput = new SAXBuilder().build(xmlqueryresultsinput);
			} 
			catch (IOException e) {
				System.err.println("IOException when opening xml document for transformation");
			}
			catch (JDOMException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		// Call
		Document results =this.derivationService.deriveStatements(xmlinput, formulationTypeString);
		
		//Keep AML-String up-to-date and write output to console
		System.out.println("Here's the text content of the Query Result: " + this.serializeTextNodeContent(xmlinput));
		String textadddummy = this.serializeTextNodeContent(results);
		String [] statements = textadddummy.split(";");
		//System.out.println("Derived " + statements.length + " new statements for a type");
		for(String s:statements){
			s=s.trim();
			if(!s.isEmpty()){
			this.currentAMLString += s + ";" + "\n";
			System.out.println("AML Derivation content:" + s);
			}
		}
		//System.out.println("Here's the text content of the AML Derivation: " + textadddummy);
		//this.currentAMLString += textadddummy + "\n";
		
		// Storage
		XMLOutputter out = new XMLOutputter();
		try {
			FileWriter fwriter = new FileWriter(xmlresultloc);
			out.output(results, fwriter);
			fwriter.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Exception when storing AML Deriavtion result");
		}
		
	}
	
	
	
	
	
	/**
	 * This method simply takes two locally stored documents for an XSLT Stylesheet and a source XML Document and applies the Transformation to the document. The result will be stored on the
	 * local machine by the path given by the result input Parameter.
	 * REMARK: THIS METHOD NOW WORKS WITH SAXON IN ORDER TO USE XSLT/XPATH 2.0 FUNCTIONALITY. IT HAS BEEN UPDATED FORM A JAXP VERSION ON 2015-08-13. See the old implementation below
	 * REMARK: 2015-08-14: This method has been renamed and is hence no more called from outside. It is deprecated since we now perform statement-derivations directly in java instead of applying XSL Transformations.
	 * @param xsltloc
	 * @param xmlloc
	 * @param resultloc
	 */
	@Deprecated public void applyXSLTonXMLfromFilesbySAXON(File xsltloc, File xmlloc, File resultloc){
	
		Processor proc = new Processor(false);
		XsltCompiler comp =  proc.newXsltCompiler();
		
		XsltExecutable executable = null;
		try {
			executable = comp.compile(new StreamSource(xsltloc));
		} catch (SaxonApiException e) {
			// TODO Auto-generated catch block
			System.err.println("IOException when opening xslt document for transformation");
			e.printStackTrace();
		}
		
		XdmNode source = null;
		try {
			source = proc.newDocumentBuilder().build(new StreamSource(xmlloc));
		} catch (SaxonApiException e) {
			// TODO Auto-generated catch block
			System.err.println("IOException when opening xml document for transformation");
			e.printStackTrace();
		}

		Serializer out = new Serializer();
		out.setOutputProperty(Serializer.Property.METHOD, "xml");
		out.setOutputFile(resultloc);
		
		XsltTransformer trans=executable.load();
		trans.setInitialContextNode(source);
		trans.setDestination(out);
		try {
			trans.transform();
		} catch (SaxonApiException e) {
			// TODO Auto-generated catch block
			System.err.println("Error during xslt transformation");
			e.printStackTrace();
		}
		
		//To Do: serialization to AML string
		/**
		// Also put out the text content of the input document:
		System.out.println("Here's the text content of the Query Result: " + this.serializeTextNodeContent(xml));
		// Let's test the result by putting it's text content in order into a string representation
		String textadddummy = this.serializeTextNodeContent(traforesult.getDocument());
		System.out.println("Here's the text content of the AML Derivation: " + textadddummy);
		this.currentAMLString += textadddummy + "\n";
		*/
	}
	
	/**
	 * This method simply takes two locally stored documents for an XSLT Stylesheet and a source XML Document and applies the Transformation to the document. The result will be stored on the
	 * local machine by the path given by the result input Parameter.
	 * REMARK: THIS IS AN OLD JAXP XSLT/XPATH 1.0 version of the transformation!
	 * @param xsltloc
	 * @param xmlloc
	 * @param resultloc
	 */
	@Deprecated public void applyXSLTonXMLfromFilesbyJAXP(File xsltloc, File xmlloc, File resultloc){
	
		// Building it all with a Transformer Factory, Sources and Results
		
		Document xml = null;
		JDOMResult traforesult= new JDOMResult();

		
		try {
				xml = new SAXBuilder().build(xmlloc);
			} 
			catch (IOException e) {
				System.err.println("IOException when opening xml document for transformation");
			}
			catch (JDOMException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		Source sourceFile = new JDOMSource( xml);
		
		Transformer transformer = null;
		try {
			System.out.println("xslt location: " + xsltloc.toString());
			transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltloc.toString()));
		} catch (TransformerConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (TransformerFactoryConfigurationError e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			transformer.transform(sourceFile, traforesult);
		} catch (TransformerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// Also put out the text content of the input document:
		System.out.println("Here's the text content of the Query Result: " + this.serializeTextNodeContent(xml));
		// Let's test the result by putting it's text content in order into a string representation
		//TODO: Overwork serialization to AML-String, see method on top.
		String textadddummy = this.serializeTextNodeContent(traforesult.getDocument());
		String [] statements = textadddummy.split(";");
		System.out.println("Derived " + statements.length + " new statements for a type");
		for(String s:statements){
			this.currentAMLString += s + "\n";
			System.out.println("AML Derivation content:" + s);
		}
		//textadddummy.replaceAll(";", Matcher.quoteReplacement("; \n"));
		//System.out.println("Here's the text content of the AML Derivation: " + textadddummy);
		//this.currentAMLString += textadddummy + "\n";
		
		// Store the result at the location given by resultloc
		
		XMLOutputter out = new XMLOutputter();
		try {
			FileWriter fwriter = new FileWriter(resultloc);
			out.output(traforesult.getDocument(), fwriter);
			fwriter.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.err.println("Exception when storing transformation result");
		}
	}
	
	/**
	 * This method extracts the text Node content of an XML Document that represents an AML Statement and builds a string out of it.
	 * To this purpose, an external XSLT Stylesheet is executed.
	 * Remark: THIS METHOD WORKS WITH XSLT/XPAHT 1.0 and the JAXP API!
	 * @param doc
	 * @return
	 */
	public String serializeTextNodeContent(Document doc){

		String returnval = "";
		
		// Building it all with a Transformer Factory, Sources and Results
		
		Source sourceFile = new JDOMSource( doc);
		JDOMResult textResult = new JDOMResult();
		
		Transformer transformer = null;
		try {
			transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(MyOwlOntologyImportHelper.getXMLLeaveContentInOrdertoTextLocation().toString()));
		} catch (TransformerConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (TransformerFactoryConfigurationError e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			transformer.transform(sourceFile, textResult);
		} catch (TransformerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		  returnval = textResult.getDocument().getRootElement().getText();
		
		
		return returnval;
	}
	
	public String getCurrentAML() {
		// TODO Auto-generated method stub
		return this.currentAMLString;
	}
}
