package de.dsor.ontooptmod.derivation;

import java.io.File;
import java.io.IOException;

import javax.xml.XMLConstants;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;


/**
 * This class is used to manage the validation and serialization process of xml documents that represent AML Statements
 * @author Florian Stapel
 *
 */
public class XMLStatementManager {
	
	private SchemaFactory sf;
	private Schema schema;
	private Validator validator;
	
	/**
	 * The constructor initializes a schema factory and an actual private Schema as well as a validator
	 * @param fileLocation
	 */
	public XMLStatementManager(File fileLocation) {
		this.sf = SchemaFactory.newInstance( XMLConstants.W3C_XML_SCHEMA_NS_URI );
		this.schema = null;
		try {
			this.schema = this.sf.newSchema( fileLocation);
		} catch (SAXException e) {
			System.err.println("IOException when opening xml Schema document");
			e.printStackTrace();
		}
		this.validator = schema.newValidator();
	}

	/**
	 * This method tries to validate the argument File against the currently loaded Schema
	 * @param xml
	 */
	public void validateXMLFileagainstcurrentSchema(File xml){
	Document xmldoc = null;

		
		try {
				xmldoc = new SAXBuilder().build(xml);
			} 
			catch (IOException e) {
				System.err.println("IOException when opening xml document for exemplary Schema validation");
			}
			catch (JDOMException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		try {
			validator.validate(new JDOMSource(xmldoc));
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			System.err.println("SAXException when validating xml document against schema");
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.err.println("IOException when validating xml document against schema");
			e.printStackTrace();
		}
		System.out.println("Validation completed");
	}
	
	/**
	 * Simple test method that tests a hard coded example file against the AMPL Statement Grammar Schema
	 */
	@Deprecated public void testAMPLSchema(){
		SchemaFactory sf = SchemaFactory.newInstance( XMLConstants.W3C_XML_SCHEMA_NS_URI );
		Schema schema = null;
		try {
			schema = sf.newSchema( new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/AMPL-Statements-XML-Grammar.xsd"));
		} catch (SAXException e) {
			System.err.println("IOException when opening xml Schema document");
			e.printStackTrace();
		}
		Validator validator = schema.newValidator();
		
		Document xmlexample = null;

		
		try {
				xmlexample = new SAXBuilder().build(new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies/Statement-Derivation/AMPL-Statements-XML-Example.xml"));
			} 
			catch (IOException e) {
				System.err.println("IOException when opening xml document for exemplary Schema validation");
			}
			catch (JDOMException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		
		try {
			validator.validate(new JDOMSource(xmlexample));
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			System.err.println("SAXException when vaidating xml document against schema");
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			System.err.println("IOException when vaidating xml document against schema");
			e.printStackTrace();
		}
		System.out.println("Validation completed");
	}
}
