package de.dsor.ontooptmod.gui;

import java.awt.EventQueue;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

import org.semanticweb.owlapi.*;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyManager;

import java.awt.BorderLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.io.*;
import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.GroupLayout.Alignment;
import javax.swing.JTable;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.border.LineBorder;

import java.awt.Color;

import de.dsor.ontooptmod.models.*;
import de.dsor.ontooptmod.derivation.*;
import de.dsor.ontooptmod.helpers.*;

public class MainWindow {

	private JFrame frmOntologyOptimizationModels;
	private JTextField txtModelID;
	private JTextArea textAreaModVoc;
	private JTextArea txtrDerivedAmlModel;
	private JTable table;
	private JTextArea textAreaAMLValidation;
	private OptimizationOntologyManager optmodel;
	private JTextField txtOntologyPathonMachine;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainWindow window = new MainWindow();
					window.frmOntologyOptimizationModels.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainWindow() {
		initialize();
		frmOntologyOptimizationModels.addWindowListener ( new DialogWindowClosingListener() );
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmOntologyOptimizationModels = new JFrame();
		frmOntologyOptimizationModels.setTitle("Ontology Optimization Models");
		frmOntologyOptimizationModels.setBounds(100, 100, 923, 472);
		frmOntologyOptimizationModels.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		frmOntologyOptimizationModels.getContentPane().add(tabbedPane, BorderLayout.NORTH);
		
		JPanel panel_modman = new JPanel();
		tabbedPane.addTab("Load Models", null, panel_modman, null);
		
		JButton btnLoadOntologyModel = new JButton("Load Ontology Model");
		btnLoadOntologyModel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				// Here we implement the File Management and loading of a specified OWL XML File. 
				// First we clear the GUI components as far as we must
				clearGUI();
				//Optionally configure the File Chooser here
				//JFileChooser chooser = new JFileChooser(new File("C:/Projekte/OntologicalOptimizationModeling/Ontologies"));
				JFileChooser chooser = new JFileChooser(new File(""));
				FileNameExtensionFilter filter = new FileNameExtensionFilter(
					"only owl xml serialization allowed", "owl");
				chooser.setFileFilter(filter);
				
				int returnval = chooser.showOpenDialog(frmOntologyOptimizationModels);
				
					if(returnval == JFileChooser.APPROVE_OPTION) {
					System.out.println("Your selected Model-File was " + chooser.getSelectedFile().getName());
					
				
					File file = chooser.getSelectedFile();
					optmodel = new OptimizationOntologyManager(file);

					// Actualize the lblModelName by the Model IRI (better URI?). To do: Imports
					txtModelID.setText(optmodel.getModelName());
					// read out Model Vocabularies and give out on GUI. To Do: Determine closure when Imports are resolved
					textAreaModVoc.setText(null);
					textAreaModVoc.append("Direct Imports:" + "\n");
					for(String s : optmodel.getModelDirectImportsAsStrings()){textAreaModVoc.append(s + "\n"); }
					textAreaModVoc.append("Indirect Imports:" + "\n");
					for(String s : optmodel.getModelIndirectImportsAsStrings()){textAreaModVoc.append(s + "\n"); }
				
					// Test the loaded Ontology Individuals on Console (call with working on merged model and imports closure)
					optmodel.allModelEntitiesOnConsole(optmodel.getmergedModel(),true);
					// Test the capabilities to find subclasses in the import closure of the merged model
					optmodel.allSubClassesonConsole(optmodel.getmergedModel(),IRI.create("http://www.semanticweb.org/florianstapel/ontologies/2014/8/OM.owl#Goal"));
				
					// Update the table for showing the model entities:
					String[] columnnames = {"Goal(s)", "Constraints" , "Variables" , "Parameters" , "Sets"};
					Object [][] data = optmodel.retrieveEntityTableData();
					
					
					// To Do: This does not seem to bing any change. Also the preedited table names do not seem to occur
					DefaultTableModel tabMod = (DefaultTableModel) table.getModel();
					//tabMod.setColumnIdentifiers(columnnames);
					//tabMod.fireTableStructureChanged();
					
					// Test whether the Table is registered as a Listener
					/*
					System.out.println("Here's the number of table model listeners: " + tabMod.getTableModelListeners().length );
					TableModelListener [] tl = tabMod.getTableModelListeners();
					System.out.println("And here comes the first listeners Type: " + tl[0].getClass());
					*/
					
				
					for (int row = 0; row < data.length; row++) {
						try{
							tabMod.addRow(data[row]);
						}
						catch(NullPointerException e){System.err.println("Nullpointer-Exception in Model Entity Table row " + row ) ;}
					}
					
				}
					
				if(returnval == JFileChooser.CANCEL_OPTION){
					JOptionPane.showMessageDialog(frmOntologyOptimizationModels, "Please select a model before proceeding");
				}
	
			}
			
			/**
			 *  Method used to manually empty the Tables and Textareas on the contentPane
			 */
			private void clearGUI() {
				// empty the table
				table.setModel(new DefaultTableModel(
						new Object[][] {
						},
						new String[] {
							"Goal(s)", "Constraints", "Sets", "Variables", "Parameter"
						}
					));
				// empty the AML Derivation Textarea
				txtrDerivedAmlModel.setText("");
				// empty the AML Derivation Validation Textarea
				textAreaAMLValidation.setText("");
			}
		});
		
		JLabel lblModelID = new JLabel("Model ID:");
		
		txtModelID = new JTextField();
		txtModelID.setText("none");
		txtModelID.setColumns(70);
		
		JLabel lblModVoc = new JLabel("Model Vocabularies:");
		
		JLabel lblModelEntities = new JLabel("Model Entities:");
		
		JScrollPane scrollPane_modvoc = new JScrollPane();
		
		JScrollPane scrollPane_modent = new JScrollPane();
		
		JLabel lblPathToOntologyfiles = new JLabel("Path to Ontology-Files:");
		
		txtOntologyPathonMachine = new JTextField();		
		txtOntologyPathonMachine.setColumns(10);
		txtOntologyPathonMachine.setText(MyOwlOntologyImportHelper.ontopathbase);
		
		
		GroupLayout gl_panel_modman = new GroupLayout(panel_modman);
		gl_panel_modman.setHorizontalGroup(
			gl_panel_modman.createParallelGroup(Alignment.TRAILING)
				.addGroup(gl_panel_modman.createSequentialGroup()
					.addGap(24)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.TRAILING)
						.addGroup(gl_panel_modman.createSequentialGroup()
							.addComponent(btnLoadOntologyModel)
							.addGap(18)
							.addComponent(lblModelID))
						.addComponent(lblModVoc)
						.addComponent(lblPathToOntologyfiles)
						.addComponent(lblModelEntities))
					.addGap(18)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.LEADING)
						.addComponent(scrollPane_modent, GroupLayout.DEFAULT_SIZE, 622, Short.MAX_VALUE)
						.addComponent(scrollPane_modvoc, GroupLayout.DEFAULT_SIZE, 622, Short.MAX_VALUE)
						.addComponent(txtModelID, 622, 622, Short.MAX_VALUE)
						.addComponent(txtOntologyPathonMachine, GroupLayout.DEFAULT_SIZE, 622, Short.MAX_VALUE))
					.addGap(54))
		);
		gl_panel_modman.setVerticalGroup(
			gl_panel_modman.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panel_modman.createSequentialGroup()
					.addGap(5)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.BASELINE)
						.addComponent(lblModelID)
						.addComponent(txtModelID, GroupLayout.PREFERRED_SIZE, 23, GroupLayout.PREFERRED_SIZE)
						.addComponent(btnLoadOntologyModel))
					.addGap(18)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.BASELINE)
						.addComponent(scrollPane_modvoc, GroupLayout.PREFERRED_SIZE, 81, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblModVoc))
					.addGap(18)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.BASELINE)
						.addComponent(scrollPane_modent, GroupLayout.PREFERRED_SIZE, 71, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblModelEntities))
					.addGap(129)
					.addGroup(gl_panel_modman.createParallelGroup(Alignment.BASELINE)
						.addComponent(lblPathToOntologyfiles)
						.addComponent(txtOntologyPathonMachine, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addGap(238))
		);
		
		
		//String[] columnnames = {"Goal(s)", "Constraints" , "Variables" , "Parameters" , "Sets"};
		//String[][] rowdata = {{"No", "Model", "loaded" , "so far" , "!"}};
		//table= new JTable(rowdata, columnnames);
		
		table = new JTable();
		//scrollPane_modent.setColumnHeaderView(table);
		scrollPane_modent.setViewportView(table);
		table.setFillsViewportHeight(true);
		table.setModel(new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Goal(s)", "Constraints", "Sets", "Variables", "Parameter"
			}
		));
		
		textAreaModVoc = new JTextArea();
		scrollPane_modvoc.setViewportView(textAreaModVoc);
		panel_modman.setLayout(gl_panel_modman);
		
		JPanel panel_AMLInst = new JPanel();
		tabbedPane.addTab("Derive AML", null, panel_AMLInst, null);
		
		JButton btnInstantiateCurrentModel = new JButton("Derive AMPL");
		btnInstantiateCurrentModel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				
				// Here's a test to get the processable documents
				txtrDerivedAmlModel.setText(optmodel.processCurrentModel2AML());
				
				//TODO: textbox, ordered, validation!
				
				/*
				// Let's try the query Execution:
				MySPARQLDLQueryManager sparqldlman = new MySPARQLDLQueryManager(optmodel.getOWLOntologyManager(), optmodel.getmergedModel());
				sparqldlman.processDemoQueries();
				
				// A little dummy execution of a statement derivation with a pre-given query result
				StatementDerivationManager statderivmanag = new StatementDerivationManager();
				
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#NodeSet", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#NodeSet", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#NodeSet", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#ArcSet", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#ArcSet", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#ArcSet", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CapacityCollection", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CapacityCollection", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CapacityCollection", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CostCollection", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CostCollection", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CostCollection", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#SupplyCollection", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#SupplyCollection", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#SupplyCollection", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#FlowCollection", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#FlowCollection", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#FlowCollection", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#GoalFlowCostLinear", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#GoalFlowCostLinear", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#GoalFlowCostLinear", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Balance", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Balance", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Balance", DType.STATEMENT_RESULT ));
				statderivmanag.applyXSLTonXMLfromFiles(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Capacity", DType.XSLT ), MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Capacity", DType.SPARQL_RESULT ) , MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Capacity", DType.STATEMENT_RESULT ));
				txtrDerivedAmlModel.setText(statderivmanag.getCurrentAML());
				*/
			}
		});
		
		JLabel lblAMLDerivResult = new JLabel("Result -->");
		
		JButton btnValidateXmlDocuments = new JButton("Validate XML Docs");
		btnValidateXmlDocuments.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				// Now let us try to validate the document against the schema
			textAreaAMLValidation.setText(optmodel.validateCurrentAMLModelagainstSchema());
			/**
			XMLStatementManager statman = new XMLStatementManager(MyOwlOntologyImportHelper.getFileLocationfromString("AMPL-Statements-XML-Grammar", DType.XSD));
			
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#NodeSet", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#ArcSet", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CapacityCollection", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#CostCollection", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#SupplyCollection", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("MDO-Network#FlowCollection", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#GoalFlowCostLinear", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Balance", DType.STATEMENT_RESULT));
			statman.validateXMLFileagainstcurrentSchema(MyOwlOntologyImportHelper.getFileLocationfromString("OM-Network-Constraints#Capacity", DType.STATEMENT_RESULT));
			
			//statman.testAMPLSchema();
			textAreaAMLValidation.setText("valid");
			*/
			}
		});
		
		JScrollPane scrollPaneAMLResult = new JScrollPane();
		
		JScrollPane scrollPaneAMLValidation = new JScrollPane();
		GroupLayout gl_panel_AMLInst = new GroupLayout(panel_AMLInst);
		gl_panel_AMLInst.setHorizontalGroup(
			gl_panel_AMLInst.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panel_AMLInst.createSequentialGroup()
					.addGap(23)
					.addGroup(gl_panel_AMLInst.createParallelGroup(Alignment.LEADING)
						.addComponent(btnInstantiateCurrentModel)
						.addGroup(gl_panel_AMLInst.createSequentialGroup()
							.addGap(100)
							.addComponent(lblAMLDerivResult))
						.addComponent(btnValidateXmlDocuments))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(gl_panel_AMLInst.createParallelGroup(Alignment.TRAILING)
						.addComponent(scrollPaneAMLValidation, GroupLayout.DEFAULT_SIZE, 664, Short.MAX_VALUE)
						.addComponent(scrollPaneAMLResult, GroupLayout.DEFAULT_SIZE, 664, Short.MAX_VALUE))
					.addContainerGap())
		);
		gl_panel_AMLInst.setVerticalGroup(
			gl_panel_AMLInst.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_panel_AMLInst.createSequentialGroup()
					.addGap(23)
					.addGroup(gl_panel_AMLInst.createParallelGroup(Alignment.BASELINE)
						.addGroup(gl_panel_AMLInst.createSequentialGroup()
							.addComponent(btnInstantiateCurrentModel)
							.addGap(44)
							.addComponent(lblAMLDerivResult))
						.addComponent(scrollPaneAMLResult, GroupLayout.DEFAULT_SIZE, 181, Short.MAX_VALUE))
					.addGap(57)
					.addGroup(gl_panel_AMLInst.createParallelGroup(Alignment.BASELINE)
						.addComponent(scrollPaneAMLValidation, GroupLayout.PREFERRED_SIZE, 133, GroupLayout.PREFERRED_SIZE)
						.addComponent(btnValidateXmlDocuments))
					.addGap(209))
		);
		
		textAreaAMLValidation = new JTextArea();
		scrollPaneAMLValidation.setViewportView(textAreaAMLValidation);
		
		txtrDerivedAmlModel = new JTextArea();
		scrollPaneAMLResult.setViewportView(txtrDerivedAmlModel);
		txtrDerivedAmlModel.setText("No AML model derived so far");
		panel_AMLInst.setLayout(gl_panel_AMLInst);
		
		JLabel lblPoweredBy = new JLabel("Powered By: DSOR / SFB Image To Do");
		frmOntologyOptimizationModels.getContentPane().add(lblPoweredBy, BorderLayout.SOUTH);
	}
}
