package de.dsor.ontooptmod.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 * This class contains helper methods to transform data in the context of Optimization Ontology Models
 * @author Florian Stapel
 *
 */
public class MyOptDataTransformHelper {

	/**
	 * This method returns a filled homogeneous Array of Strings from an ArrayList of ArrayLists of String values 
	 * @param tabledata
	 * @return
	 */
	public static String[][] getStringArrayfromArrayListofStringCollections(ArrayList<ArrayList<String>> tabledata){
		
		System.out.println("----------Trying to convert some 2D ArrayList Table Data to a 2D String Array------");

		// Get count of rows and columns and initialize result structure;
		int rows = 0;
		
		for(Collection<String> actcollect: tabledata){
			rows = Math.max(rows, actcollect.size());
		}
		
	    int cols = tabledata.size();
		System.out.println("-------------------------The number of input lists is " + cols + " ---------------------------");
		
		String [][] returnValues = new String [rows][cols];
		
	    // Transform the data
		
		Iterator<ArrayList<String>> myInputRowIterator = tabledata.iterator(); 
		for(int j=0; j<cols; j++){
			System.out.println("-------------------------Now entering Column " + j + " ----------------------------------");
			if(myInputRowIterator.hasNext())
			{
				Iterator<String> myInputColIterator = myInputRowIterator.next().iterator();
					for(int i=0;i<rows;i++){
						System.out.println("--------------------------Now entering row " + i + " ---------------------------------");
						if(myInputColIterator.hasNext())
						{returnValues[i][j]= myInputColIterator.next();}
						else{returnValues[i][j] = "";}
					}
			}
			else {System.out.println("getStringArrayfromArrayListofStringCollections: I am missing row number " + j + " in the input");}
		}
		
		System.out.println("---------------------------------Conversion finished------------------------------------");
		
		return returnValues;
		}
}
